/*
 * @(#) ViewContextAction.java Oct 23, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.logger.gui.LoggerSelectFrame;

/**
 * The ViewContext action <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class ViewLoggerAction extends AbstractAction
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new ViewContextAction
	 * 
	 * @param application the application
	 */
	public ViewLoggerAction(final DSOLApplicationInterface application)
	{
		super("Logging");
		this.application = application;
		this.putValue(Action.MNEMONIC_KEY, new Integer('L'));
		this.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(
				KeyEvent.VK_F9, 0));
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent e)
	{
		try
		{
			boolean running = false;
			try
			{
				if (this.application.getExperiment().getSimulator().isRunning())
				{
					running = true;
					this.application.getExperiment().getSimulator().stop();
				}
			} catch (NullPointerException nullPointerException)
			{
				//This was meant to happen
				nullPointerException = null;
			}
			new LoggerSelectFrame();
			if (running)
			{
				this.application.getExperiment().getSimulator().start();
			}
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}
	}
}