/*
 * @(#) ExperimentParsingThread.java Mar 2, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.panels;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;

import javax.swing.JOptionPane;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.xml.dsol.ExperimentParser;
import nl.tudelft.simulation.xml.dsol.ExperimentParsingThread;

/**
 * A ExperimentParsingThread <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Mar 2, 2004 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class GUIExperimentParsingThread extends ExperimentParsingThread
{

	/** the parent component */
	protected Component parent = null;

	/**
	 * constructs a new ExperimentParsingThread
	 * 
	 * @param source the source of this thread
	 * @param parent the parent component
	 * @param experiment the experiment to parse
	 */
	public GUIExperimentParsingThread(final EventListenerInterface source,
			final Component parent, final URL experiment)
	{
		super(source, experiment);
		this.parent = parent;
	}

	/**
	 * @see java.lang.Runnable#run()
	 */
	public void run()
	{
		WaitingFrame waitingFrame = new WaitingFrame();
		try
		{
			Experiment experiment = ExperimentParser
					.parseExperiment(this.experiment);
			this.source.notify(new Event(EXPERIMENT_PARSED_EVENT, this,
					experiment));
			waitingFrame.dispose();
		} catch (IOException exception)
		{
			waitingFrame.dispose();
			Logger.warning(this, "run", exception);
			JOptionPane.showMessageDialog(this.parent,
					exception.getClass().getName()
							.substring(
									exception.getClass().getName().lastIndexOf(
											".") + 1)
							+ " occurred while loading "
							+ this.experiment
							+ ".\n", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
}