/*
 * @(#) TabbedPane.java Oct 14, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.panels;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JTabbedPane;

/**
 * The TabbedPane <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class TabbedPane extends JTabbedPane
{
	/** the content of the tabbedPane */
	private Map content = new HashMap();

	/**
	 * constructs a new TabbedPane
	 */
	public TabbedPane()
	{
		super();
	}

	/**
	 * constructs a new TabbedPane
	 * 
	 * @param tabPlacement the placement
	 */
	public TabbedPane(final int tabPlacement)
	{
		super(tabPlacement);
	}

	/**
	 * constructs a new TabbedPane
	 * 
	 * @param tabPlacement the placement
	 * @param tabLayoutPolicy the policy
	 */
	public TabbedPane(final int tabPlacement, final int tabLayoutPolicy)
	{
		super(tabPlacement, tabLayoutPolicy);
	}

	/**
	 * adds a component to the pane
	 * 
	 * @param title the title of the component
	 * @param index the index position at which the component will be placed.
	 * @param component the component
	 * @return the component
	 */
	public Component add(final String title, final int index,
			final Component component)
	{
		this.content.put(title, component);
		component.setName(title);
		return super.add(component, index);
	}

	/**
	 * removes the component from the tabbedPane
	 * 
	 * @param title the title of the tab
	 */
	public void remove(final String title)
	{
		Component component = (Component) this.content.get(title);
		if (component != null)
		{
			this.remove(component);
		}
	}
}