/**
 * @(#) ChartPanel.java Oct 17, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.statistics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import nl.tudelft.simulation.dsol.gui.panels.TablePanel;
import nl.tudelft.simulation.dsol.gui.statistics.actions.AddColumnAction;
import nl.tudelft.simulation.dsol.gui.statistics.actions.AddRowAction;
import nl.tudelft.simulation.dsol.gui.statistics.actions.DeleteColumnAction;
import nl.tudelft.simulation.dsol.gui.statistics.actions.DeleteRowAction;
import nl.tudelft.simulation.jstats.Swingable;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.InitialEventContext;

/**
 * The ChartPanel <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class ChartPanel extends JPanel implements DropTargetListener
{
	/** the contentPanel of this chartPanel */
	private TablePanel contentPanel = new TablePanel(2, 2);

	/**
	 * constructs a new ChartPanel
	 */
	public ChartPanel()
	{
		super();
		this.initialize();
		this.validate();
		this.repaint();
		new DropTarget(this, DnDConstants.ACTION_COPY_OR_MOVE, this);
	}

	/**
	 * adds a row to the panel
	 */
	public void addRow()
	{
		this.contentPanel.addRow();
		for (int c = 0; c < this.contentPanel.getColumns(); c++)
		{
			JPanel panel = new JPanel();
			panel.setPreferredSize(this.getMaximumSize());
			panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			this.contentPanel
					.setCell(panel, this.contentPanel.getRows() - 1, c);
		}
	}

	/**
	 * adds a column
	 */
	public void addColumn()
	{
		this.contentPanel.addColumn();
		for (int r = 0; r < this.contentPanel.getRows(); r++)
		{
			JPanel panel = new JPanel();
			panel.setPreferredSize(this.getMaximumSize());
			panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			this.contentPanel.setCell(panel, r,
					this.contentPanel.getColumns() - 1);
		}
	}

	/**
	 * deletes a row
	 */
	public void deleteRow()
	{
		this.contentPanel.deleteRow();
	}

	/**
	 * deletes a row
	 */
	public void deleteColumn()
	{
		this.contentPanel.deleteColumn();
	}

	/**
	 * @see java.awt.dnd.DropTargetListener
	 *      #drop(java.awt.dnd.DropTargetDropEvent)
	 */
	public void drop(final DropTargetDropEvent dropEvent)
	{
		try
		{
			Transferable tr = dropEvent.getTransferable();
			if (dropEvent.isDataFlavorSupported(DataFlavor.stringFlavor))
			{
				dropEvent.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
				dropEvent.dropComplete(true);
				String key = (String) tr
						.getTransferData(DataFlavor.stringFlavor);
				Swingable chart = (Swingable) new InitialEventContext()
						.lookup(key);
				this.contentPanel.setCell(chart.getSwingPanel(),
						this.contentPanel.getRow(dropEvent.getLocation()),
						this.contentPanel.getColumn(dropEvent.getLocation()));
				this.validate();
				this.repaint();

			} else
			{
				dropEvent.rejectDrop();
			}
		} catch (Exception ufe)
		{
			Logger.warning(this, "drop", ufe);
		}
	}

	/**
	 * @see java.awt.dnd.DropTargetListener
	 *      #dragEnter(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dragEnter(final DropTargetDragEvent e)
	{
		//The chartPanel does not react on enters
	}

	/**
	 * @see java.awt.dnd.DropTargetListener
	 *      #dragExit(java.awt.dnd.DropTargetEvent)
	 */
	public void dragExit(final DropTargetEvent e)
	{
		//The chartPanel does not react on exits
	}

	/**
	 * @see java.awt.dnd.DropTargetListener
	 *      #dragOver(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dragOver(final DropTargetDragEvent e)
	{
		//The chartPanel does not react on overs
	}

	/**
	 * @see java.awt.dnd.DropTargetListener
	 *      #dropActionChanged(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dropActionChanged(final DropTargetDragEvent e)
	{
		//The chartPanel does not react on action changes
	}

	/**
	 * initializes the chartPanel
	 */
	private void initialize()
	{
		this.setBorder(BorderFactory.createEmptyBorder());
		this.setLayout(new BorderLayout());

		JPanel buttons = new JPanel();
		buttons.setBorder(BorderFactory.createEmptyBorder());
		buttons.setLayout((new BoxLayout(buttons, BoxLayout.X_AXIS)));

		JButton addRowButton = new JButton(new AddRowAction(this));
		buttons.add(addRowButton);

		JButton deleteRowButton = new JButton(new DeleteRowAction(this));
		buttons.add(deleteRowButton);

		JButton addColumnButton = new JButton(new AddColumnAction(this));
		buttons.add(addColumnButton);

		JButton deleteColumnButton = new JButton(new DeleteColumnAction(this));
		buttons.add(deleteColumnButton);

		TablePanel buttonHolder = new TablePanel(1, 1);
		buttonHolder.setBorder(BorderFactory.createEmptyBorder());

		buttonHolder.setCell(buttons, 0, 0);
		this.add(buttonHolder, BorderLayout.SOUTH);
		this.add(this.contentPanel, BorderLayout.CENTER);

		for (int r = 0; r < this.contentPanel.getRows(); r++)
		{
			for (int c = 0; c < this.contentPanel.getColumns(); c++)
			{
				JPanel panel = new JPanel();
				panel.setPreferredSize(this.getMaximumSize());
				panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
				this.contentPanel.setCell(panel, r, c);
			}
		}
	}
}