/*
 * @(#) StatisticsTree.java Oct 19, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.statistics;

import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;

import javax.naming.NamingException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.jstats.Swingable;
import nl.tudelft.simulation.naming.InitialEventContext;
import nl.tudelft.simulation.naming.context.ContextTransferable;
import nl.tudelft.simulation.naming.context.ContextTreeModel;
import nl.tudelft.simulation.naming.context.SimpleDragSourceListener;

/**
 * The StatisticsTree extends a Tree and drags an object <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class StatisticsTree extends JTree implements DragGestureListener,
		EventListenerInterface
{

	/**
	 * constructs a new StatisticsTree
	 * 
	 * @throws NamingException on failure
	 */
	public StatisticsTree() throws NamingException
	{
		super(new ContextTreeModel(new InitialEventContext(),
				new Class[]{Swingable.class}, false));
		DragSource dragSource = DragSource.getDefaultDragSource();
		dragSource.createDefaultDragGestureRecognizer(this,
				DnDConstants.ACTION_COPY_OR_MOVE, this);
	}

	/**
	 * @see java.awt.dnd.DragGestureListener
	 *      #dragGestureRecognized(java.awt.dnd.DragGestureEvent)
	 */
	public void dragGestureRecognized(final DragGestureEvent dge)
	{
		try
		{
			TreePath path = getLeadSelectionPath();
			DefaultMutableTreeNode node = (DefaultMutableTreeNode) path
					.getLastPathComponent();
			dge.startDrag(DragSource.DefaultCopyDrop, new ContextTransferable(
					node.getUserObject()), new SimpleDragSourceListener());
		} catch (Exception nullPointerException)
		{
			//Customer dragged without selection. Nor problem, we may ignore
			return;
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		this.validate();
		this.repaint();
	}
}