/*
 * @(#) MemoryFrame.java Nov 5, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import nl.tudelft.simulation.dsol.gui.panels.TablePanel;
import nl.tudelft.simulation.logger.Logger;

/**
 * @author peter
 */
public class MemoryFrame extends JFrame implements ActionListener
{
	/** freeMem */
	private JTextField freeMemoryField = new JTextField();

	/** usedMem */
	private JTextField totalMemoryField = new JTextField();

	/** total Mem */
	private JTextField usedMemoryField = new JTextField();

	/**
	 * constructs a new MemoryFrame
	 *  
	 */
	public MemoryFrame()
	{
		super("Memory information");
		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		this.initialize();
		new Worker(this).start();
		this.pack();
		this.setResizable(false);
		this.setVisible(true);
	}

	/**
	 * initializes
	 */
	private void initialize()
	{
		this.freeMemoryField.setEditable(false);
		this.usedMemoryField.setEditable(false);
		this.totalMemoryField.setEditable(false);
		JPanel panel = new JPanel(new BorderLayout());
		TablePanel buttonPanel = new TablePanel(1, 1);
		JButton button = new JButton("Clean garbage now !");
		button.addActionListener(this);
		buttonPanel.setCell(button, 0, 0);
		panel.add(buttonPanel, BorderLayout.SOUTH);
		TablePanel memoryPanel = new TablePanel(3, 2);
		memoryPanel.setBorder(BorderFactory.createTitledBorder("Memory"));
		JTextField freeLabel = new JTextField("Free memory (bytes)");
		freeLabel.setEditable(false);
		JTextField usedLabel = new JTextField("Used memory (bytes)");
		usedLabel.setEditable(false);
		JTextField totalLabel = new JTextField("Total memory (bytes)");
		totalLabel.setEditable(false);
		memoryPanel.setCell(freeLabel, 0, 0);
		memoryPanel.setCell(usedLabel, 1, 0);
		memoryPanel.setCell(totalLabel, 2, 0);
		memoryPanel.setCell(this.freeMemoryField, 0, 1);
		memoryPanel.setCell(this.usedMemoryField, 1, 1);
		memoryPanel.setCell(this.totalMemoryField, 2, 1);
		panel.add(memoryPanel, BorderLayout.CENTER);
		this.setContentPane(panel);
		this.validate();
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		Runtime.getRuntime().gc();
		this.repaint();
	}

	/**
	 * gets freeMemoryField
	 * 
	 * @return Returns the freeMemoryField.
	 */
	protected JTextField getFreeMemoryField()
	{
		return this.freeMemoryField;
	}

	/**
	 * gets totalMemoryField
	 * 
	 * @return Returns the totalMemoryField.
	 */
	protected JTextField getTotalMemoryField()
	{
		return this.totalMemoryField;
	}

	/**
	 * gets usedMemoryField
	 * 
	 * @return Returns the usedMemoryField.
	 */
	protected JTextField getUsedMemoryField()
	{
		return this.usedMemoryField;
	}

	/**
	 * @author peter
	 */
	private class Worker extends Thread
	{
		/** a formatter */
		private NumberFormat formatter = NumberFormat.getInstance();

		/** the memoryFrame */
		private MemoryFrame frame = null;

		/**
		 * constructs a new SimulatorRunThread
		 * 
		 * @param frame the frame.
		 */
		public Worker(final MemoryFrame frame)
		{
			super();
			this.frame = frame;
			this.formatter.setMaximumFractionDigits(1);
		}

		/**
		 * @see java.lang.Runnable#run()
		 */
		public void run()
		{
			try
			{
				while (true)
				{
					long free = Runtime.getRuntime().freeMemory();
					long total = Runtime.getRuntime().totalMemory();
					long used = total - free;
					this.frame
							.getFreeMemoryField()
							.setText(
									free
											+ "  ("
											+ this.formatter
													.format((free / (double) total) * 100)
											+ "%)");
					this.frame
							.getUsedMemoryField()
							.setText(
									used
											+ "  ("
											+ this.formatter
													.format((used / (double) total) * 100)
											+ "%)");
					this.frame.getTotalMemoryField().setText(
							total + "  (100.0%)");
					MemoryFrame.this.validate();
					MemoryFrame.this.repaint();
					Thread.sleep(3500);
				}
			} catch (Exception exception)
			{
				Logger.warning(this, "run", exception);
			}
		}
	}
}