/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.actions.SimulatorAction;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

public class PauseAction
extends SimulatorAction {
    public PauseAction(DSOLApplicationInterface application) {
        super("Pause Simulator At...", application);
        this.putValue("MnemonicKey", new Integer(115));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 512));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Pause16.gif")));
    }

    protected void notifyStopped() {
        try {
            this.simulator.stop();
            JOptionPane.showMessageDialog(null, "Pausing simulation @ " + this.simulator.getSimulatorTime() + " on user's request.");
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"notifyStopped", (Throwable)exception);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String result = JOptionPane.showInputDialog("Enter desired pause-time");
        if (result != null) {
            try {
                double value = Double.parseDouble(result);
                if (!(value > this.simulator.getSimulatorTime() || new Double(this.simulator.getSimulatorTime()).isNaN() && value >= 0.0)) {
                    throw new Exception();
                }
                ((DEVSSimulatorInterface)this.simulator).scheduleEvent((SimEventInterface)new SimEvent(value, 1, (Object)this, (Object)this, "notifyStopped", null));
                JOptionPane.showMessageDialog(null, "Succesfully scheduled pause @ " + value);
            }
            catch (Exception exception) {
                try {
                    JOptionPane.showMessageDialog(null, "Invalid input: " + result + ". Value should be numerical and larger than " + "simulator time:" + this.simulator.getSimulatorTime());
                }
                catch (RemoteException remoteException) {
                    Logger.warning((Object)this, (String)"actionPerformed", (Throwable)remoteException);
                }
            }
        }
    }
}

