/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation2D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation2D.AnimationPanel;
import nl.tudelft.simulation.dsol.gui.animation2D.GridPanel;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.HomeAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanDownAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanLeftAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanRightAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanUpAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.ShowGridAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.ZoomInAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.ZoomOutAction;

public class AnimationFrame
extends JFrame {
    public AnimationFrame(DSOLApplicationInterface application) {
        this("Animation window", application);
    }

    public AnimationFrame(String name, DSOLApplicationInterface application) {
        super(name);
        this.getContentPane().setLayout(new BorderLayout());
        Rectangle2D.Double extent = null;
        String extentString = application.getProperties().getProperty("dsol-gui.animation.panel.extent");
        if (extentString != null) {
            double[] values = new double[4];
            for (int i = 0; i < 3; ++i) {
                values[i] = new Double(extentString.substring(0, extentString.indexOf(";")));
                extentString = extentString.substring(extentString.indexOf(";") + 1);
            }
            values[3] = new Double(extentString);
            extent = new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
        } else {
            extent = new Rectangle2D.Double(-100.0, -100.0, 200.0, 200.0);
        }
        String sizeString = application.getProperties().getProperty("dsol-gui.animation.panel.size");
        Dimension size = new Dimension(600, 600);
        if (sizeString != null) {
            double width = new Double(sizeString.substring(0, sizeString.indexOf(";")));
            double height = new Double(sizeString.substring(sizeString.indexOf(";") + 1));
            size = new Dimension((int)width, (int)height);
        }
        AnimationPanel panel = new AnimationPanel(extent, size, application);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)new ButtonPanel(panel), "South");
        this.pack();
        ((Component)this).setVisible(true);
        panel.requestFocus();
    }

    public static class ButtonPanel
    extends JPanel {
        public ButtonPanel(GridPanel target) {
            this.setLayout(new FlowLayout(1, 1, 1));
            JButton zoomIn = new JButton(new ZoomInAction(target));
            JButton zoomOut = new JButton(new ZoomOutAction(target));
            JButton left = new JButton(new PanLeftAction(target));
            JButton right = new JButton(new PanRightAction(target));
            JButton up = new JButton(new PanUpAction(target));
            JButton down = new JButton(new PanDownAction(target));
            JButton grid = new JButton(new ShowGridAction(target));
            JButton home = new JButton(new HomeAction(target));
            this.add(zoomIn);
            this.add(zoomOut);
            this.add(left);
            this.add(right);
            this.add(up);
            this.add(down);
            this.add(grid);
            this.add(home);
        }
    }
}

