/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation3D.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

public class ZoomMouseBehavior
extends MouseBehavior {
    private double zFactor = 0.04;
    private Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;
    private TransformGroup rotateXGroup = null;
    private TransformGroup rotateYGroup = null;
    private Transform3D rotateX = new Transform3D();
    private Transform3D rotateY = new Transform3D();

    public ZoomMouseBehavior(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public ZoomMouseBehavior() {
        super(0);
    }

    public ZoomMouseBehavior(int flags) {
        super(flags);
    }

    public ZoomMouseBehavior(Component c) {
        super(c, 0);
    }

    public ZoomMouseBehavior(Component c, TransformGroup transformGroup) {
        super(c, transformGroup);
    }

    public ZoomMouseBehavior(Component c, int flags) {
        super(c, flags);
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.zFactor *= -1.0;
            this.invert = true;
        }
    }

    public double getFactor() {
        return this.zFactor;
    }

    public void setFactor(double factor) {
        this.zFactor = factor;
    }

    public void setRotateXGroup(TransformGroup rotateXGroup) {
        this.rotateXGroup = rotateXGroup;
    }

    public void setRotateYGroup(TransformGroup rotateYGroup) {
        this.rotateYGroup = rotateYGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent evt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    void doProcess(MouseEvent evt) {
        this.processMouseEvent(evt);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int id = evt.getID();
            if (id == 506 && evt.isAltDown() && !evt.isMetaDown()) {
                this.y = evt.getY();
                int dy = this.y - this.y_last;
                if (!this.reset && Math.abs(dy) < 50) {
                    this.transformGroup.getTransform(this.currXform);
                    this.translation.x = 0.0;
                    this.translation.y = 0.0;
                    this.translation.z = (double)(-dy) * this.zFactor;
                    this.transformX.setZero();
                    if (this.rotateYGroup != null && this.rotateXGroup != null) {
                        this.rotateYGroup.getTransform(this.rotateY);
                        this.rotateXGroup.getTransform(this.rotateX);
                        this.transformX.set(this.rotateY);
                        this.transformX.mul(this.rotateX);
                        this.transformX.transform(this.translation);
                    }
                    this.transformX.set(this.translation);
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                    }
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(2, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (id == 501) {
                this.x_last = evt.getX();
                this.y_last = evt.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

