/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.windows.URLChooserFrame;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class OpenURLAction
extends AbstractAction
implements EventListenerInterface {
    private DSOLApplicationInterface application = null;

    public OpenURLAction(DSOLApplicationInterface application) {
        super("Open URL");
        this.application = application;
        this.putValue("MnemonicKey", new Integer(85));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 128));
        this.setEnabled(false);
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"OpenURLAction", (Throwable)exception);
        }
    }

    public void actionPerformed(ActionEvent event) {
        new URLChooserFrame(this.application);
    }

    protected void finalize() throws Throwable {
        this.application.removeListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        super.finalize();
    }

    public void notify(EventInterface event) {
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            if (event.getContent() == null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

