/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.UIInitializer;
import nl.tudelft.simulation.dsol.gui.menu.FileMenu;
import nl.tudelft.simulation.dsol.gui.menu.HelpMenu;
import nl.tudelft.simulation.dsol.gui.menu.ToolsMenu;
import nl.tudelft.simulation.dsol.gui.menu.WindowMenu;
import nl.tudelft.simulation.dsol.gui.panels.ControlPanel;
import nl.tudelft.simulation.dsol.gui.panels.ExperimentTree;
import nl.tudelft.simulation.dsol.gui.panels.Statusbar;
import nl.tudelft.simulation.dsol.gui.panels.TabbedPane;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.logger.Logger;

public class DSOLFrame
extends JFrame
implements EventListenerInterface {
    public static final Dimension PREFERRED_SIZE = new Dimension(400, 375);
    protected DSOLApplicationInterface application = null;
    protected TabbedPane tabbedPanel = null;
    protected JTree experimentTree = null;
    protected Statusbar statusbar = null;
    protected ControlPanel controlPanel = null;

    public DSOLFrame(DSOLApplicationInterface application) {
        super("DSOL main window");
        try {
            UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            UIInitializer.initialize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((int)Math.round((double)screenSize.width * 0.5 - 0.5 * (double)DSOLFrame.PREFERRED_SIZE.width), (int)Math.round((double)screenSize.height * 0.33 - 0.5 * (double)DSOLFrame.PREFERRED_SIZE.height));
            this.application = application;
            this.setDefaultCloseOperation(3);
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"DSOLFrame", (Throwable)exception);
        }
        this.initialize();
        this.pack();
        ((Component)this).setVisible(true);
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setPreferredSize(PREFERRED_SIZE);
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        menuBar.add(new FileMenu(this.application));
        menuBar.add(new ToolsMenu(this.application));
        menuBar.add(new WindowMenu(this.application));
        menuBar.add(new HelpMenu(this.application));
        this.setJMenuBar(menuBar);
        this.controlPanel = new ControlPanel(this.application);
        this.tabbedPanel = new TabbedPane(1);
        this.tabbedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder()));
        contentPane.add((Component)this.tabbedPanel, "Center");
        this.statusbar = new Statusbar(this.application);
        this.experimentTree = new JTree();
        this.experimentTree.setEditable(false);
        this.experimentTree.setFocusable(false);
        URL about = URLResource.getResource((String)"/nl/tudelft/simulation/dsol/gui/about.html");
        JEditorPane aboutPane = null;
        try {
            aboutPane = new JEditorPane(about);
        }
        catch (IOException exception) {
            Logger.warning((Object)this, (String)"initialize", (Throwable)exception);
        }
        aboutPane.setAlignmentY(1.0f);
        aboutPane.setEditable(false);
        this.tabbedPanel.add("About", aboutPane);
    }

    public void notify(EventInterface event) {
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            this.tabbedPanel.remove("Description");
            this.tabbedPanel.remove("Experiment");
            this.tabbedPanel.remove("Control");
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                try {
                    String descriptionName = "/";
                    if (experiment.getModel().getClass().getPackage() != null) {
                        descriptionName = descriptionName + experiment.getModel().getClass().getPackage().getName().replace('.', '/');
                    }
                    descriptionName = descriptionName + "/package.html";
                    URL description = experiment.getModel().getClass().getResource(descriptionName);
                    JEditorPane descriptionPane = null;
                    descriptionPane = new JEditorPane(description);
                    descriptionPane.setAlignmentY(1.0f);
                    descriptionPane.setEditable(false);
                    this.tabbedPanel.add("Description", 0, new JScrollPane(descriptionPane));
                }
                catch (IOException exception) {
                    Logger.fine((Object)this, (String)"initialize", (String)"experiment has no package.html describing the experiment");
                }
                this.setTitle("DSOL main window (" + experiment.getProperty("EXPERIMENT_NAME") + ")");
                this.experimentTree.setModel(new ExperimentTree(experiment));
                this.tabbedPanel.add("Experiment", 1, new JScrollPane(this.experimentTree));
                this.tabbedPanel.add("Control", 2, this.controlPanel);
                this.getContentPane().add((Component)this.statusbar, "South");
            } else {
                this.setTitle("DSOL main window");
                this.getContentPane().remove(this.statusbar);
            }
            this.validate();
            this.repaint();
        }
    }
}

