/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.GUIExperimentParsingThread;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class FileChooserFrame
extends JFrame
implements ActionListener,
EventListenerInterface {
    private DSOLApplicationInterface application = null;

    public FileChooserFrame(DSOLApplicationInterface application, String directory) {
        super("open experiment");
        ((Component)this).setLocation(75, 50);
        this.application = application;
        this.initialize(directory);
        this.pack();
        ((Component)this).setVisible(true);
    }

    private void initialize(String directory) {
        JFileChooser fileChooser = new JFileChooser(directory);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith("xml") || file.isDirectory();
            }

            public String getDescription() {
                return ".xml experiment files";
            }
        });
        fileChooser.addActionListener(this);
        this.getContentPane().add((Component)fileChooser, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!actionEvent.getActionCommand().equals("CancelSelection")) {
            File selectedFile = ((JFileChooser)actionEvent.getSource()).getSelectedFile();
            try {
                this.dispose();
                ((Thread)((Object)new GUIExperimentParsingThread(this, this, selectedFile.toURL()))).start();
            }
            catch (MalformedURLException e) {
                Logger.warning((Object)this, (String)"actionPerformed", (Throwable)e);
            }
        } else {
            this.dispose();
        }
    }

    public void notify(EventInterface event) {
        this.application.setExperiment((Experiment)event.getContent());
    }
}

