/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.GUIExperimentParsingThread;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;

public class URLChooserFrame
extends JFrame
implements EventListenerInterface {
    private JTextField addressField;
    private DSOLApplicationInterface application = null;

    public URLChooserFrame(DSOLApplicationInterface application) {
        super("Enter the URL of an experiment");
        ((Component)this).setLocation(100, 150);
        this.application = application;
        this.initialize();
    }

    private void initialize() {
        JPanel contentPane = new JPanel(new BorderLayout());
        JPanel addressPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)addressPanel, "Center");
        JPanel addressBar = new JPanel(new BorderLayout());
        addressBar.setBorder(new CompoundBorder(new BevelBorder(0), new EmptyBorder(2, 2, 2, 2)));
        addressPanel.add((Component)addressBar, "Center");
        addressBar.add((Component)new JLabel("Address: "), "West");
        this.addressField = new JTextField();
        this.addressField.addActionListener(new AddressEntered(this));
        addressBar.add((Component)this.addressField, "Center");
        addressPanel.setPreferredSize(new Dimension(600, (int)addressBar.getPreferredSize().getHeight()));
        this.setContentPane(contentPane);
        this.pack();
        ((Component)this).setVisible(true);
    }

    protected JTextField getAddressField() {
        return this.addressField;
    }

    protected DSOLApplicationInterface getApplication() {
        return this.application;
    }

    public void notify(EventInterface event) {
        this.application.setExperiment((Experiment)event.getContent());
    }

    private class AddressEntered
    extends AbstractAction {
        private URLChooserFrame frame = null;

        public AddressEntered(URLChooserFrame frame) {
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent event) {
            URLChooserFrame.this.dispose();
            String address = this.frame.getAddressField().getText();
            try {
                if (address.indexOf("://") == -1) {
                    address = "http://" + address;
                }
                URL url = new URL(address);
                ((Thread)((Object)new GUIExperimentParsingThread(this.frame, this.frame, url))).start();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(URLChooserFrame.this, exception.getClass().getName().substring(exception.getClass().getName().lastIndexOf(".") + 1) + " occurred while connecting to " + address + ".\n", "Error", 0);
                return;
            }
        }
    }
}

