/*
 * @(#) ShowGridAction.java Oct 24, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.rmi.RemoteException;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The AnimationDelaySlider <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class AnimationDelaySlider extends JSlider implements
		EventListenerInterface, ChangeListener
{
	/** the animator */
	private AnimatorInterface simulator;

	/** fired */
	private boolean fired = false;

	/**
	 * constructs a new ShowGridAction
	 * 
	 * @param application the application
	 */
	public AnimationDelaySlider(final DSOLApplicationInterface application)
	{
		super(0, 3000, 100);
		this.setEnabled(false);
		this.addChangeListener(this);
		try
		{
			application.addListener(this,
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
			this.notify(new Event(
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT,
					application, application.getExperiment()));
		} catch (RemoteException exception)
		{
			Logger.warning(this, "AnimationDelaySlider", exception);
		}
	}

	/**
	 * @see javax.swing.event.ChangeListener
	 *      #stateChanged(javax.swing.event.ChangeEvent)
	 */
	public void stateChanged(final ChangeEvent event)
	{
		if (this.simulator == null)
		{
			return;
		}
		if (this.fired)
		{
			this.fired = false;
			return;
		}
		this.fired = true;
		try
		{
			boolean shoudPause = this.simulator.isRunning();
			JSlider slider = (JSlider) event.getSource();
			double value = Math.pow(10, (double) slider.getValue() / 1000) - 1;
			if (shoudPause)
			{
				this.simulator.stop();
			}
			this.simulator.setAnimationDelay(Math.round(value));
			if (shoudPause)
			{
				this.simulator.start();
			}
			this.validate();
			this.repaint();
		} catch (Exception exception)
		{
			Logger.warning(this, "stateChanged", exception);
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event) throws RemoteException
	{
		if (event.getType().equals(
				AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT)
				&& event.getSource() instanceof SimulatorInterface)
		{
			this.setValue((int) Math.round((Math
					.log(((Long) event.getContent()).longValue()) / Math
					.log(10)) * 1000));
		}
		if (event.getType().equals(
				DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)
				&& event.getSource() instanceof DSOLApplicationInterface)
		{
			if (event.getContent() != null)
			{
				Experiment experiment = (Experiment) event.getContent();
				experiment
						.addListener(this, Experiment.SIMULATOR_CHANGED_EVENT);
				this.notify(new Event(Experiment.SIMULATOR_CHANGED_EVENT,
						experiment, experiment.getSimulator()));
			}
			return;
		}
		if (event.getType().equals(Experiment.SIMULATOR_CHANGED_EVENT)
				&& event.getSource() instanceof Experiment)
		{
			if (event.getContent() != null)
			{
				if (event.getContent() instanceof AnimatorInterface)
				{
					this.simulator = (AnimatorInterface) event.getContent();
					this.notify(new Event(
							AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT,
							this.simulator, new Long(this.simulator
									.getAnimationDelay())));
					this.simulator.addListener(this,
							AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT);
					this.setEnabled((true));
				}
			}
		}
	}
}