/*
 * @(#) ShowGridAction.java Oct 24, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The StopAction <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class StopAction extends SimulatorAction implements
		EventListenerInterface
{
	/**
	 * constructs a new ShowGridAction
	 * 
	 * @param application the application
	 */
	public StopAction(final DSOLApplicationInterface application)
	{
		super("stop", application);
		this.putValue(Action.SMALL_ICON, new ImageIcon(this.getClass()
				.getResource("/toolbarButtonGraphics/media/Stop16.gif")));
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		try
		{
			super.simulator.stop();
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		super.notify(event);
		if (event.getType().equals(SimulatorInterface.START_EVENT))
		{
			this.setEnabled(true);
			return;
		}
		if (event.getType().equals(SimulatorInterface.STOP_EVENT))
		{
			this.setEnabled(false);
			return;
		}
	}
}