/*
 * @(#) ContentBranch.java May 10, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.animation3D;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

/**
 * ContentBranch, the content branch of the scene graph <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 10.05.2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class ContentBranch extends BranchGroup
{
	/** The light branch */
	protected BranchGroup lightBranch = new BranchGroup();

	/** The dynamic object branch */
	protected BranchGroup dynamicObjectBranch = new BranchGroup();

	/** The static object branch */
	protected BranchGroup staticObjectBranch = new BranchGroup();

	/**
	 * Construct the scene graph
	 */
	public ContentBranch()
	{
		super();
		createBranch();
	}

	/**
	 * Create the content branch
	 */
	protected void createBranch()
	{
		// set capabilities of content branch
		this.setCapability(Group.ALLOW_CHILDREN_READ);
		this.setCapability(Group.ALLOW_CHILDREN_WRITE);
		this.setCapability(Group.ALLOW_CHILDREN_EXTEND);
		this.setCapability(BranchGroup.ALLOW_DETACH);
		this.setCapability(Node.ALLOW_PICKABLE_READ);
		this.setCapability(Node.ALLOW_PICKABLE_WRITE);

		// set capabilities of the dynamic branch
		this.dynamicObjectBranch.setCapability(Group.ALLOW_CHILDREN_READ);
		this.dynamicObjectBranch.setCapability(Group.ALLOW_CHILDREN_WRITE);
		this.dynamicObjectBranch.setCapability(Group.ALLOW_CHILDREN_EXTEND);
		this.dynamicObjectBranch.setCapability(BranchGroup.ALLOW_DETACH);
		this.dynamicObjectBranch.setCapability(Node.ALLOW_PICKABLE_READ);
		this.dynamicObjectBranch.setCapability(Node.ALLOW_PICKABLE_READ);

		// set capabilities of the static branch
		this.staticObjectBranch.setCapability(Group.ALLOW_CHILDREN_READ);
		this.staticObjectBranch.setCapability(Group.ALLOW_CHILDREN_WRITE);
		this.staticObjectBranch.setCapability(Group.ALLOW_CHILDREN_EXTEND);
		this.staticObjectBranch.setCapability(BranchGroup.ALLOW_DETACH);

		// Transform so that Z axis points upward
		Transform3D transform = new Transform3D();
		transform.set(new AxisAngle4d(1.0, 0.0, 0.0, Math.PI * -.5));
		TransformGroup rootTransformGroup = new TransformGroup(transform);
		// set capabilities of the rootTransformGroup
		rootTransformGroup.setCapability(Group.ALLOW_CHILDREN_READ);
		rootTransformGroup.setCapability(Group.ALLOW_CHILDREN_WRITE);
		rootTransformGroup.setCapability(Group.ALLOW_CHILDREN_EXTEND);
		rootTransformGroup.setCapability(Node.ALLOW_PICKABLE_READ);
		rootTransformGroup.setCapability(Node.ALLOW_PICKABLE_READ);

		// Add some default light to the darkness
		this.addLights(this.lightBranch);

		// Build the scene
		this.addChild(rootTransformGroup);
		rootTransformGroup.addChild(this.dynamicObjectBranch);
		rootTransformGroup.addChild(this.lightBranch);
		rootTransformGroup.addChild(this.staticObjectBranch);
		//contentBranch.compile();
	}

	/**
	 * Add lights
	 * 
	 * @param branchGroup The branch group to add the light to
	 */
	protected void addLights(final BranchGroup branchGroup)
	{
		// Create bounding sphere for the light
		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0),
				1000.0);

		// Setup ambient light
		Color3f ambientColor = new Color3f(0.4f, 0.4f, 0.4f);
		AmbientLight ambientLight = new AmbientLight(ambientColor);
		ambientLight.setInfluencingBounds(bounds);

		// Setup directional light
		Color3f lightColor = new Color3f(0.2f, 0.2f, 0.2f);
		Vector3f lightDirection = new Vector3f(-1.0f, -0.7f, -0.5f);
		DirectionalLight light = new DirectionalLight(lightColor,
				lightDirection);
		light.setInfluencingBounds(bounds);

		// Add lights to branch group
		branchGroup.addChild(ambientLight);
		branchGroup.addChild(light);
	}

	/**
	 * @return LightBranch
	 */
	public BranchGroup getLightBranch()
	{
		return this.lightBranch;
	}

	/**
	 * @return DynamicObjectBranch: dynamic objects
	 */
	public BranchGroup getDynamicObjectBranch()
	{
		return this.dynamicObjectBranch;
	}

	/**
	 * @return StaticObjectBranch: static objects
	 */
	public BranchGroup getStaticObjectBranch()
	{
		return this.staticObjectBranch;
	}

}