/*
 * $RCSfile: TranslateMouseBehavior.java,v $
 * A modification of MouseTranslate.java *
 *
 * Copyright (c) 2004 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 * $Revision: 1.1 $
 * $Date: 2004/09/28 09:44:32 $
 * $State: Exp $
 */
/*
 * Modified to translate with axis rotations taking into account. 
 * Copyright (c) 2003 Delft University of Technology 
 * Jaffalaan 5, 2628 BX Delft, the Netherlands All
 * rights reserved.
 */
package nl.tudelft.simulation.dsol.gui.animation3D.mouse;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;

/**
 * Translation behavior defines how the camera is translated. Based on
 * com.sun.j3d.utils.behaviors.mouse.MouseTranslate.
 */
public class TranslateMouseBehavior extends MouseBehavior
{
    /** x translation factor */
    private double xFactor = .02;

    /** y translation factor */
    private double yFactor = .02;

    /** translation vector */
    private Vector3d translation = new Vector3d();

    /** mouse behavior callback */
    private MouseBehaviorCallback callback = null;

    /** rotation group around x-axis */
    private TransformGroup rotateXGroup = null;

    /** rotation group around y-axis */
    private TransformGroup rotateYGroup = null;

    /** rotation around x-axis */
    private Transform3D rotateX = new Transform3D();

    /** rotation around y-axis */
    private Transform3D rotateY = new Transform3D();

    /**
     * Creates a mouse translate behavior given the transform group.
     * 
     * @param transformGroup The transformGroup to operate on.
     */
    public TranslateMouseBehavior(final TransformGroup transformGroup)
    {
        super(transformGroup);
    }

    /**
     * Creates a default translate behavior.
     */
    public TranslateMouseBehavior()
    {
        super(0);
    }

    /**
     * Creates a translate behavior. Note that this behavior still needs a
     * transform group to work on (use setTransformGroup(tg)) and the transform
     * group must add this behavior.
     * 
     * @param flags flags
     */
    public TranslateMouseBehavior(final int flags)
    {
        super(flags);
    }

    /**
     * Creates a translate behavior that uses AWT listeners and behavior posts
     * rather than WakeupOnAWTEvent. The behavior is added to the specified
     * Component. A null component can be passed to specify the behavior should
     * use listeners. Components can then be added to the behavior with the
     * addListener(Component c) method.
     * 
     * @param c The Component to add the MouseListener and MouseMotionListener
     *            to.
     * @since Java 3D 1.2.1
     */
    public TranslateMouseBehavior(final Component c)
    {
        super(c, 0);
    }

    /**
     * Creates a translate behavior that uses AWT listeners and behavior posts
     * rather than WakeupOnAWTEvent. The behaviors is added to the specified
     * Component and works on the given TransformGroup. A null component can be
     * passed to specify the behavior should use listeners. Components can then
     * be added to the behavior with the addListener(Component c) method.
     * 
     * @param c The Component to add the MouseListener and MouseMotionListener
     *            to.
     * @param transformGroup The TransformGroup to operate on.
     * @since Java 3D 1.2.1
     */
    public TranslateMouseBehavior(final Component c,
            final TransformGroup transformGroup)
    {
        super(c, transformGroup);
    }

    /**
     * Creates a translate behavior that uses AWT listeners and behavior posts
     * rather than WakeupOnAWTEvent. The behavior is added to the specified
     * Component. A null component can be passed to specify the behavior should
     * use listeners. Components can then be added to the behavior with the
     * addListener(Component c) method. Note that this behavior still needs a
     * transform group to work on (use setTransformGroup(tg)) and the transform
     * group must add this behavior.
     * 
     * @param c The Component to add the MouseListener and MouseMotionListener
     *            to.
     * @param flags interesting flags (wakeup conditions).
     * @since Java 3D 1.2.1
     */
    public TranslateMouseBehavior(final Component c, final int flags)
    {
        super(c, flags);
    }

    /**
     * @see javax.media.j3d.Behavior#initialize()
     */
    public void initialize()
    {
        super.initialize();
        if ((flags & INVERT_INPUT) == INVERT_INPUT)
        {
            invert = true;
            this.xFactor *= -1;
            this.yFactor *= -1;
        }
    }

    /**
     * @return the x-axis movement multipler.
     */
    public double getXFactor()
    {
        return this.xFactor;
    }

    /**
     * @return the y-axis movement multipler.
     */
    public double getYFactor()
    {
        return this.yFactor;
    }

    /**
     * Set the x-axis amd y-axis movement multipler with factor.
     * 
     * @param factor same factor for both x and y
     */
    public void setFactor(final double factor)
    {
        this.xFactor = factor;
        this.yFactor = factor;
    }

    /**
     * Set the x-axis amd y-axis movement multipler with xFactor and yFactor
     * respectively.
     * 
     * @param xFactor the xFactor
     * @param yFactor the yFactor
     */
    public void setFactor(final double xFactor, final double yFactor)
    {
        this.xFactor = xFactor;
        this.yFactor = yFactor;
    }

    /**
     * Set the rotation around the x-axis.
     * 
     * @param rotateXGroup rotation around x-axis.
     */
    public void setRotateXGroup(final TransformGroup rotateXGroup)
    {
        this.rotateXGroup = rotateXGroup;
    }

    /**
     * Set the rotation around the y-axis.
     * 
     * @param rotateYGroup rotation around y-axis.
     */
    public void setRotateYGroup(final TransformGroup rotateYGroup)
    {
        this.rotateYGroup = rotateYGroup;
    }

    /**
     * @see javax.media.j3d.Behavior#processStimulus(java.util.Enumeration)
     */
    public void processStimulus(final Enumeration criteria)
    {
        WakeupCriterion wakeup;
        AWTEvent[] events;
        MouseEvent evt;
        // 	int id;
        // 	int dx, dy;

        while (criteria.hasMoreElements())
        {
            wakeup = (WakeupCriterion) criteria.nextElement();

            if (wakeup instanceof WakeupOnAWTEvent)
            {
                events = ((WakeupOnAWTEvent) wakeup).getAWTEvent();
                if (events.length > 0)
                {
                    evt = (MouseEvent) events[events.length - 1];
                    doProcess(evt);
                }
            } else if (wakeup instanceof WakeupOnBehaviorPost)
            {
                while (true)
                {
                    // access to the queue must be synchronized
                    synchronized (mouseq)
                    {
                        if (mouseq.isEmpty())
                        {
                            break;
                        }
                        evt = (MouseEvent) mouseq.remove(0);
                        // consolodate MOUSE_DRAG events
                        while ((evt.getID() == MouseEvent.MOUSE_DRAGGED)
                                && !mouseq.isEmpty()
                                && (((MouseEvent) mouseq.get(0)).getID() == MouseEvent.MOUSE_DRAGGED))
                        {
                            evt = (MouseEvent) mouseq.remove(0);
                        }
                    }
                    doProcess(evt);
                }
            }

        }
        wakeupOn(mouseCriterion);
    }

    /**
     * @param evt mouse event
     */
    void doProcess(final MouseEvent evt)
    {
        int id;
        int dx, dy;

        processMouseEvent(evt);

        if (((buttonPress) && ((flags & MANUAL_WAKEUP) == 0))
                || ((wakeUp) && ((flags & MANUAL_WAKEUP) != 0)))
        {
            id = evt.getID();
            if ((id == MouseEvent.MOUSE_DRAGGED) && !evt.isAltDown()
                    && evt.isMetaDown())
            {

                this.x = evt.getX();
                this.y = evt.getY();

                dx = this.x - this.x_last;
                dy = this.y - this.y_last;

                if ((!reset) && ((Math.abs(dy) < 50) && (Math.abs(dx) < 50)))
                {
                    //System.out.println("dx " + dx + " dy " + dy);
                    this.transformGroup.getTransform(this.currXform);

                    this.translation.x = dx * this.xFactor;
                    this.translation.y = -dy * this.yFactor;
                    this.translation.z = 0;

                    this.transformX.setZero();

                    // Now do some rotations around the x- and y-axis if these
                    // are available.
                    if ((this.rotateYGroup != null)
                            && (this.rotateXGroup != null))
                    {
                        this.rotateYGroup.getTransform(this.rotateY);
                        this.rotateXGroup.getTransform(this.rotateX);
                        this.transformX.set(this.rotateY);
                        this.transformX.mul(this.rotateX);

                        // transform the translation
                        this.transformX.transform(this.translation);
                    }
                    this.transformX.set(this.translation);

                    if (this.invert)
                    {
                        this.currXform.mul(this.currXform, this.transformX);
                    } else
                    {
                        this.currXform.mul(this.transformX, this.currXform);
                    }

                    this.transformGroup.setTransform(this.currXform);

                    this.transformChanged(this.currXform);

                    if (this.callback != null)
                    {
                        this.callback
                                .transformChanged(
                                        MouseBehaviorCallback.TRANSLATE,
                                        this.currXform);
                    }

                } else
                {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (id == MouseEvent.MOUSE_PRESSED)
            {
                this.x_last = evt.getX();
                this.y_last = evt.getY();
            }
        }
    }

    /**
     * Users can overload this method which is called every time the Behavior
     * updates the transform
     * 
     * Default implementation does nothing
     * 
     * @param transform the transform
     */
    public void transformChanged(final Transform3D transform)
    {
        // Nothing
    }

    /**
     * The transformChanged method in the callback class will be called every
     * time the transform is updated
     * 
     * @param callback callback
     */
    public void setupCallback(final MouseBehaviorCallback callback)
    {
        this.callback = callback;
    }
}