/*
 * @(#) NavigationToolbar.java 20-jul-2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import nl.tudelft.simulation.dsol.gui.animation2D.GridPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.NavigationToolbarActions;
import nl.tudelft.simulation.language.io.URLResource;

/**
 * NavigationToolbar.java <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class NavigationToolbar extends JToolBar
{
    /** Pan left button */
    private JButton panLeft = null;

    /** Pan right button */
    private JButton panRight = null;

    /** Pan uo button */
    private JButton panUp = null;

    /** Pan down button */
    private JButton panDown = null;

    /** Zoom in button */
    private JButton zoomIn = null;

    /** Zoom out button */
    private JButton zoomOut = null;

    /** Home button */
    private JButton home = null;

    /** Troggle grid button */
    private JButton troggleGrid = null;

    /** Action listener */
    private NavigationToolbarActions actions = null;

    /**
     * Constructs the toolbar
     * 
     * @param target
     *            Target grid panel
     */
    public NavigationToolbar(final GridPanel target)
    {
        super();
        this.setFloatable(true);
        this.setOrientation(SwingConstants.HORIZONTAL);
        this.setRollover(true);

        // Initialize actions
        this.actions = new NavigationToolbarActions(this, target);

        // Buttons
        this.panLeft = createButton("", "Pan left",
                "/toolbarButtonGraphics/navigation/Back16.gif");

        this.panRight = createButton("", "Pan right",
                "/toolbarButtonGraphics/navigation/Forward16.gif");

        this.panUp = createButton("", "Pan up",
                "/toolbarButtonGraphics/navigation/Up16.gif");

        this.panDown = createButton("", "Pan down",
                "/toolbarButtonGraphics/navigation/Down16.gif");

        this.zoomIn = createButton("", "Zoom in",
                "/toolbarButtonGraphics/general/ZoomIn16.gif");

        this.zoomOut = createButton("", "Zoom out",
                "/toolbarButtonGraphics/general/ZoomOut16.gif");

        this.home = createButton("", "Home",
                "/toolbarButtonGraphics/navigation/Home16.gif");

        this.troggleGrid = createButton("", "Troggle grid",
                "/editorToolbarButtons/grid.GIF");

        this.add(this.panLeft);
        this.add(this.panRight);
        this.add(this.panUp);
        this.add(this.panDown);
        this.add(this.zoomIn);
        this.add(this.zoomOut);
        this.add(this.home);
        this.add(this.troggleGrid);

    }

    /**
     * Create a toolbar button
     * 
     * @param text
     *            Text on the button
     * @param tooltip
     *            Tooltip text
     * @param icon
     *            Location of icon
     * @return Button
     */
    private JButton createButton(final String text, final String tooltip,
            final String icon)
    {
        JButton button = new JButton(text, new ImageIcon(URLResource
                .getResource(icon)));
        button.setToolTipText(tooltip);
        button.addActionListener(this.actions);
        return button;
    }

    /**
     * @return Returns the panDown.
     */
    public JButton getPanDown()
    {
        return this.panDown;
    }

    /**
     * @return Returns the panLeft.
     */
    public JButton getPanLeft()
    {
        return this.panLeft;
    }

    /**
     * @return Returns the panRight.
     */
    public JButton getPanRight()
    {
        return this.panRight;
    }

    /**
     * @return Returns the panUp.
     */
    public JButton getPanUp()
    {
        return this.panUp;
    }

    /**
     * @return Returns the zoomIn.
     */
    public JButton getZoomIn()
    {
        return this.zoomIn;
    }

    /**
     * @return Returns the zoomOut.
     */
    public JButton getZoomOut()
    {
        return this.zoomOut;
    }

    /**
     * @return Returns the home.
     */
    public JButton getHome()
    {
        return this.home;
    }

    /**
     * @return Returns the troggleGrid.
     */
    public JButton getTroggleGrid()
    {
        return this.troggleGrid;
    }
}