/*
 * @(#) EditMenuActions.java 25-jul-2004 Copyright (c) 2003 Delft University of
 * Technology Jaffalaan 5, 2628 BX Delft, the Netherlands All rights reserved.
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import nl.tudelft.simulation.dsol.gui.editor2D.EditMenu;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;

/**
 * EditMenuActions.java <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class EditMenuActions implements ActionListener
{

	/** tHe source object */
	private EditMenu source = null;

	/** The editalbe animation panel */
	private Editor2DPanel panel = null;

	/**
	 * Constructor
	 * 
	 * @param source The source object
	 * @param panel The Editor2DPanel
	 */
	public EditMenuActions(final EditMenu source, final Editor2DPanel panel)
	{
		super();
		this.source = source;
		this.panel = panel;
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		Object src = event.getSource();
		if (src.equals(this.source.getMoveItem()))
		{
			panel.setSelectedEditMode(Editor2DPanel.EDIT_MODE_MOVE);
		} else if (src.equals(this.source.getRotateItem()))
		{
			panel.setSelectedEditMode(Editor2DPanel.EDIT_MODE_ROTATE);
		} else if (src.equals(this.source.getAddPointItem()))
		{
			EditorUtilities.addPointToEditable(
			        panel.getSelectedEditableRenderable(),
			        this.panel);
		}
	}

}