/*
 * @(#) EditorToolbarActions.java 20-jul-2004 Copyright (c) 2003 Delft
 * University of Technology Jaffalaan 5, 2628 BX Delft, the Netherlands All
 * rights reserved. This software is proprietary information of Delft University
 * of Technology The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.swing.JMenuItem;

import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.EditorToolbar;
import nl.tudelft.simulation.logger.Logger;

/**
 * EditorToolbarActions.java <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class EditorToolbarActions implements ActionListener
{
	/** Parent */
	private EditorToolbar source = null;

	/** The panel */
	private Editor2DPanel panel = null;

	/**
	 * Constructor
	 * 
	 * @param source The EditorToolbar
	 * @param panel The panel
	 */
	public EditorToolbarActions(final EditorToolbar source,
			final Editor2DPanel panel)
	{
		super();
		this.source = source;
		this.panel = panel;
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		Object src = event.getSource();

		// De-select all toogle buttons
		this.source.getSelectObject().setSelected(false);
		this.source.getNewObject().setSelected(false);
		this.source.getEditObject().setSelected(false);
		this.source.getDeleteObject().setSelected(false);
		panel.setSelectedMode(Editor2DPanel.MODE_IDLE);

		// Determine action and do it
		if (src.equals(this.source.getSelectObject()))
		{
			this.source.getSelectObject().setSelected(true);
			panel.setSelectedMode(Editor2DPanel.MODE_SELECT);
		} else if (src.equals(this.source.getNewObject()))
		{
			this.source.getNewObject().setSelected(true);
			panel.setSelectedMode(Editor2DPanel.MODE_NEW);

			this.source.getItems().show(this.source.getNewObject(), 0, 0);

		} else if (src.equals(this.source.getEditObject()))
		{
			this.source.getEditObject().setSelected(true);
			panel.setSelectedMode(Editor2DPanel.MODE_EDIT);
		} else if (src.equals(this.source.getDeleteObject()))
		{
			EditorUtilities.deleteEditable(panel
					.getSelectedEditableRenderable(), this.panel);
			// Object deleted: switch to select mode
			panel.setSelectedMode(Editor2DPanel.MODE_SELECT);
			this.source.getSelectObject().setSelected(true);
			this.source.getSelectObject().requestFocus();
		} else if (src instanceof JMenuItem)
		{
			// Determination of what object to create
			String text = ((JMenuItem) src).getText();
			Class editableClass = null;
			try
			{
				Map editables = Editable.listEditables();
				Set keys = editables.keySet();
				// Loop over the keys to find the classes in the Map.
				Iterator i = keys.iterator();
				boolean found = false;
				while ((i.hasNext()) && (!found))
				{
					String key = (String) i.next();
					if (key.equals(text))
					{
						String className = (String) editables.get(key);
						editableClass = Class.forName(className);
						found = true;
					}
				}
			} catch (Exception exception)
			{
				Logger.warning(this, "actionPerformed", exception);
			}

			// Set the creation of the object if editableClass is not null
			if (editableClass != null)
			{
				panel.setSelectedRenderableClass(editableClass);
			}

			// Make sure the new-button is pressed
			this.source.getNewObject().setSelected(true);
			panel.setSelectedMode(Editor2DPanel.MODE_NEW);
		}

	}

}