/*
 * @(#) MenuBarActions.java 20-jul-2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingConstants;

import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.animation.D2.EditableRenderable2DInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.EditableSaverInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.MenuBar;
import nl.tudelft.simulation.logger.Logger;

/**
 * MenuBarActions.java <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class MenuBarActions implements ActionListener
{

	/** Menubar */
	private MenuBar source = null;

	/** The application */
	private DSOLApplicationInterface application = null;

	/**
	 * Constructor
	 * 
	 * @param source Parent
	 * @param application The application
	 */
	public MenuBarActions(final MenuBar source,
			final DSOLApplicationInterface application)
	{
		super();
		this.source = source;
		this.application = application;
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		Object src = event.getSource();
		if (src.equals(this.source.getExitItem()))
		{
			this.source.getParentFrame().setVisible(false);
		} else if (src.equals(this.source.getSaveEditablesItem()))
		{
			try
			{
				// SAVE editables
				// First find all editables
				List editables = new ArrayList();
				Editor2DPanel panel = this.source.getSource()
						.getEditableAnimationPanel();
				for (Iterator i = panel.getElements().iterator(); i.hasNext();)
				{
					Renderable2DInterface renderable = (Renderable2DInterface) i
							.next();
					if (renderable instanceof EditableRenderable2DInterface)
					{
						Editable editable = (Editable) renderable.getSource();
						editables.add(editable);
					}
				}
				// Now call the save method
				String editableSaver = application.getProperties().getProperty(
						"dsol-gui.editor2D.panel.editableSaver");

				if (editableSaver != null)
				{
					try
					{
						Class editableSaverClass = Class.forName(editableSaver);
						EditableSaverInterface saver = (EditableSaverInterface) editableSaverClass
								.newInstance();
						saver.saveEditables(editables);
					} catch (Exception exception)
					{
						Logger.warning(this, "actionPerformed", exception);
					}
				}
			} catch (ClassCastException exception)
			{
				Logger.warning(this, "actionPerformed", exception);
			}
		} else if (src.equals(this.source.getNavigationItem()))
		{
			// Note: this code is currently not used because it
			// did not work as expected.
			JCheckBoxMenuItem item = (JCheckBoxMenuItem) src;
			if (item.getState())
			{
				this.source.getParentFrame().addJToolBar(
						this.source.getParentFrame().getNavigationToolbar(),
						SwingConstants.TOP);
			} else
			{
				this.source.getParentFrame().removeJToolBar(
						this.source.getParentFrame().getNavigationToolbar());
				this.source.getParentFrame().repaint();
				this.source.getParentFrame().getContentPane().repaint();
			}
		}

	}

}