/*
 * @(#) FileMenu.java Nov 5, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewAnimation3dAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewAnimationPanelAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewContextAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewEventlistAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewLoggerAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewMemoryAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewStatisticsAction;
import nl.tudelft.simulation.logger.Logger;

/**
 * The WindowMenu <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class WindowMenu extends JMenu
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new FileMenu
	 * 
	 * @param application the application
	 */
	public WindowMenu(final DSOLApplicationInterface application)
	{
		super("Window");
		this.application = application;
		this.setMnemonic('W');
		this.initialize();
	}

	/**
	 * initializes the menu
	 */
	private void initialize()
	{
		try
		{
			JMenuItem contextItem = new JMenuItem(new ViewContextAction(
					this.application));
			this.add(contextItem);
		} catch (Exception exception)
		{
			Logger.warning(this, "initialize", exception);
		}

		JMenuItem statisticsItem = new JMenuItem(new ViewStatisticsAction(
				this.application));
		this.add(statisticsItem);

		JMenuItem animationItem = new JMenuItem(new ViewAnimationPanelAction(
				this.application));
		this.add(animationItem);

		JMenuItem eventListItem = new JMenuItem(new ViewEventlistAction(
				this.application));
		this.add(eventListItem);

		JMenuItem animation3dItem = new JMenuItem(new ViewAnimation3dAction(
				this.application));
		this.add(animation3dItem);

		/*
		 * Roy, the editable windows are not considered stable and therefore not sumbitted to the 1.60 release of DSOL. 
		 * They are planned for future releases..
		 * JMenuItem editableAnimationItem = new JMenuItem( new
		 * ViewEditor2DPanelAction(this.application));
		 * this.add(editableAnimationItem);
		 */
		
		this.add(new JSeparator());

		JMenuItem loggerItem = new JMenuItem(new ViewLoggerAction(
				this.application));
		this.add(loggerItem);

		JMenuItem memoryItem = new JMenuItem(new ViewMemoryAction(
				this.application));
		this.add(memoryItem);
	}
}