/*
 * @(#) StatisticsFrame.java Oct 17, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.statistics;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.naming.NamingException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import nl.tudelft.simulation.logger.Logger;

/**
 * The StatisticsFrame <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 18.10.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class StatisticsFrame extends JFrame
{
	/**
	 * constructs a new StatisticsFrame
	 */
	public StatisticsFrame()
	{
		super("statistics");
		try
		{
			this.initialize();
		} catch (Exception exception)
		{
			Logger.warning(this, "StatisticsFrame", exception);
		}
		this.pack();
		this.setVisible(true);
	}

	/**
	 * initializes the statisticsFrame
	 * 
	 * @throws NamingException on failure
	 */
	public void initialize() throws NamingException
	{
		JPanel contentPane = new JPanel(new BorderLayout());
		contentPane.setPreferredSize(new Dimension(800, 500));

		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);

		splitPane.add(new JScrollPane(new StatisticsTree()));
		splitPane.add(new ChartPanel());
		splitPane.setDividerLocation(150);
		contentPane.add(splitPane, BorderLayout.CENTER);

		this.setContentPane(contentPane);
	}
}