/*
 * @(#) DeleteRowAction.java Oct 29, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.gui.statistics.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

import nl.tudelft.simulation.dsol.gui.statistics.ChartPanel;
import nl.tudelft.simulation.language.io.URLResource;

/**
 * DeleteRowAction <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.1 05.11.2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class DeleteRowAction extends AbstractAction
{
	/** target of the chartpanel */
	private ChartPanel target = null;

	/**
	 * constructs a new DeleteRowAction
	 * 
	 * @param target the target
	 */
	public DeleteRowAction(final ChartPanel target)
	{
		super("DeleteRow");
		this.target = target;
		this.putValue(Action.SMALL_ICON, new ImageIcon(URLResource
				.getResource("/toolbarButtonGraphics/table/RowDelete24.gif")));
		this.setEnabled(true);
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent actionEvent)
	{
		new Worker(this.target).start();
	}

	/** SimulatorRunThread extends Thread */
	private class Worker extends Thread
	{
		/** the source */
		private ChartPanel target = null;

		/**
		 * constructs a new
		 * 
		 * @param target the target
		 */
		public Worker(final ChartPanel target)
		{
			this.target = target;
		}

		/**
		 * @see java.lang.Runnable#run()
		 */
		public void run()
		{
			synchronized (this.target)
			{
				this.target.deleteRow();
			}
		}
	}
}