package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;

import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.GUIExperimentParsingThread;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;

/**
 * The URLChooserFrame provides an addess bar for the selection of an URL
 */
public class URLChooserFrame extends JFrame implements EventListenerInterface
{

	/**
	 * The address text field.
	 * 
	 * @uml.property name="addressField"
	 */
	private JTextField addressField;

	/**
	 * the DSOL application
	 * 
	 * @uml.property name="application"
	 */
	private DSOLApplicationInterface application = null;


	/**
	 * Creates a new empty HTML panel.
	 * 
	 * @param application application
	 */
	public URLChooserFrame(final DSOLApplicationInterface application)
	{
		super("Enter the URL of an experiment");
		this.setLocation(100, 150);
		this.application = application;
		this.initialize();
	}

	/**
	 * initializes the URLChooserFrame
	 */
	private void initialize()
	{
		JPanel contentPane = new JPanel(new BorderLayout());
		JPanel addressPanel = new JPanel(new BorderLayout());
		contentPane.add(addressPanel, BorderLayout.CENTER);
		JPanel addressBar = new JPanel(new BorderLayout());
		addressBar.setBorder(new CompoundBorder(new BevelBorder(
				BevelBorder.RAISED), new EmptyBorder(2, 2, 2, 2)));
		addressPanel.add(addressBar, BorderLayout.CENTER);
		addressBar.add(new JLabel("Address: "), BorderLayout.WEST);
		this.addressField = new JTextField();
		this.addressField.addActionListener(new AddressEntered(this));
		addressBar.add(this.addressField, BorderLayout.CENTER);
		addressPanel.setPreferredSize(new Dimension(600, (int) addressBar
				.getPreferredSize().getHeight()));
		this.setContentPane(contentPane);
		this.pack();
		this.setVisible(true);
	}

	/**
	 * gets addressField
	 * 
	 * @return Returns the addressField.
	 * 
	 * @uml.property name="addressField"
	 */
	protected JTextField getAddressField()
	{
		return this.addressField;
	}

	/**
	 * gets application
	 * 
	 * @return Returns the application.
	 * 
	 * @uml.property name="application"
	 */
	protected DSOLApplicationInterface getApplication()
	{
		return this.application;
	}

	/**
	 * Responds to an address change.
	 */
	private class AddressEntered extends AbstractAction
	{

		/** the URLChooserFrame */
		private URLChooserFrame frame = null;

		/**
		 * constructs a new AddressEntered
		 * 
		 * @param frame the frame
		 */
		public AddressEntered(final URLChooserFrame frame)
		{
			this.frame = frame;
		}

		/**
		 * @see java.awt.event.ActionListener
		 *      #actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(final ActionEvent event)
		{
			URLChooserFrame.this.dispose();
			String address = this.frame.getAddressField().getText();
			try
			{
				if (address.indexOf("://") == -1)
				{
					address = "http://" + address;
				}
				URL url = new URL(address);
				new GUIExperimentParsingThread(this.frame, this.frame, url)
						.start();
			} catch (Exception exception)
			{
				JOptionPane.showMessageDialog(URLChooserFrame.this,
						exception.getClass().getName()
								.substring(
										exception.getClass().getName()
												.lastIndexOf(".") + 1)
								+ " occurred while connecting to "
								+ address
								+ ".\n", "Error", JOptionPane.ERROR_MESSAGE);
				return;
			}
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		this.application.setExperiment((Experiment) event.getContent());
	}
}