/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public abstract class SimulatorAction
extends AbstractAction
implements EventListenerInterface {
    protected SimulatorInterface simulator = null;
    protected DSOLApplicationInterface application = null;

    public SimulatorAction(String name, DSOLApplicationInterface application) {
        super(name);
        this.application = application;
        this.setEnabled(false);
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"SimulatorAction", (Throwable)exception);
        }
    }

    protected void finalize() throws Throwable {
        this.application.removeListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        if (this.simulator != null) {
            this.simulator.removeListener((EventListenerInterface)this, SimulatorInterface.START_EVENT);
            this.simulator.removeListener((EventListenerInterface)this, SimulatorInterface.STOP_EVENT);
        }
        super.finalize();
    }

    protected void setSimulator(SimulatorInterface simulator) {
        try {
            if (this.simulator != null) {
                simulator.removeListener((EventListenerInterface)this, SimulatorInterface.START_EVENT);
                simulator.removeListener((EventListenerInterface)this, SimulatorInterface.STOP_EVENT);
            }
            this.simulator = simulator;
            if (simulator == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.simulator.addListener((EventListenerInterface)this, SimulatorInterface.START_EVENT);
                this.simulator.addListener((EventListenerInterface)this, SimulatorInterface.STOP_EVENT);
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"actionPerformed", (Throwable)exception);
        }
    }

    public void notify(EventInterface event) {
        if (event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT) && event.getSource() instanceof DSOLApplicationInterface) {
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                experiment.addListener((EventListenerInterface)this, Experiment.END_OF_EXPERIMENT_EVENT);
                this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
            } else {
                this.setEnabled(false);
            }
            return;
        }
        if (event.getType().equals((Object)Experiment.END_OF_EXPERIMENT_EVENT) && event.getSource() instanceof Experiment) {
            this.setEnabled(false);
        }
        if (event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT) && event.getSource() instanceof Experiment) {
            this.setSimulator((SimulatorInterface)event.getContent());
        }
    }
}

