/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation2D;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.vecmath.Point4i;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation2D.GridPanel;
import nl.tudelft.simulation.dsol.gui.animation2D.Renderable2DComparator;
import nl.tudelft.simulation.dsol.gui.animation2D.mouse.InputListener;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.InitialEventContext;

public class AnimationPanel
extends GridPanel
implements EventListenerInterface,
NamespaceChangeListener {
    private SortedSet elements = Collections.synchronizedSortedSet(new TreeSet(new Renderable2DComparator()));
    private DSOLApplicationInterface application = null;
    private EventContext context = null;
    private boolean showGrid = true;
    private Point4i dragLine = new Point4i();
    private boolean dragLineEnabled = false;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$gui$animation2D$AnimationPanel;

    public AnimationPanel(Rectangle2D extent, Dimension size, DSOLApplicationInterface application) {
        super(extent, size);
        ((GridPanel)this).showGrid = false;
        this.application = application;
        String mouseEditorClassName = this.application.getProperties().getProperty("dsol-gui.animation.panel.mouseEditor");
        InputListener listener = new InputListener(application, this);
        if (mouseEditorClassName != null) {
            try {
                Class<?> editorClass = Class.forName(mouseEditorClassName);
                Constructor<?> constructor = editorClass.getConstructor(class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface == null ? (class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface = AnimationPanel.class$("nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface")) : class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface, class$nl$tudelft$simulation$dsol$gui$animation2D$AnimationPanel == null ? (class$nl$tudelft$simulation$dsol$gui$animation2D$AnimationPanel = AnimationPanel.class$("nl.tudelft.simulation.dsol.gui.animation2D.AnimationPanel")) : class$nl$tudelft$simulation$dsol$gui$animation2D$AnimationPanel);
                this.addMouseListener((MouseListener)constructor.newInstance(application, this));
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"<init>", (String)("could not load " + mouseEditorClassName));
                listener = new InputListener(application, this);
            }
        } else {
            this.addMouseListener(listener);
        }
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.addKeyListener(listener);
        this.initialize();
    }

    private void initialize() {
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"initialize", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        SortedSet sortedSet = this.elements;
        synchronized (sortedSet) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                ((Renderable2DInterface)i.next()).paint(g2, this.getExtent(), this.getSize(), (ImageObserver)this);
            }
        }
        if (this.showGrid) {
            this.drawGrid(g);
        }
        if (this.dragLineEnabled) {
            g.setColor(Color.BLACK);
            g.drawLine(this.dragLine.w, this.dragLine.x, this.dragLine.y, this.dragLine.z);
            this.dragLineEnabled = false;
        }
    }

    public void notify(EventInterface event) throws RemoteException {
        AnimatorInterface simulator;
        if (event.getSource() instanceof AnimatorInterface && event.getType().equals((Object)AnimatorInterface.UPDATE_ANIMATION_EVENT)) {
            if (this.getWidth() > 0 || this.getHeight() > 0) {
                this.repaint();
            }
            return;
        }
        if (event.getSource() instanceof AnimatorInterface && event.getType().equals((Object)SimulatorInterface.START_REPLICATION_EVENT)) {
            this.elements.clear();
            simulator = (AnimatorInterface)event.getSource();
            String contextName = this.application.getExperiment().getRun() + "/treatment(" + simulator.getReplication().getRunControl().getTreatment().getNumber() + ")/replication(" + simulator.getReplication().getNumber() + ")/animation/2D";
            try {
                if (this.context != null) {
                    this.context.removeNamingListener(this);
                }
                this.context = (EventContext)new InitialEventContext().lookup(contextName);
                this.context.addNamingListener("", 2, (NamingListener)this);
                NamingEnumeration<Binding> list = this.context.listBindings("");
                while (list.hasMore()) {
                    Binding binding = list.next();
                    this.objectAdded(new NamingEvent(this.context, -1, binding, binding, null));
                }
                this.repaint();
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"notify", (Throwable)exception);
            }
        }
        if (event.getSource() instanceof Experiment && event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT)) {
            this.elements.clear();
            this.repaint();
            if (event.getContent() instanceof AnimatorInterface && event.getContent() != null) {
                simulator = (AnimatorInterface)event.getContent();
                simulator.addListener((EventListenerInterface)this, AnimatorInterface.UPDATE_ANIMATION_EVENT);
                if (simulator.getReplication() != null) {
                    this.notify((EventInterface)new Event(SimulatorInterface.START_REPLICATION_EVENT, (Object)simulator, (Object)simulator));
                } else {
                    simulator.addListener((EventListenerInterface)this, SimulatorInterface.START_REPLICATION_EVENT);
                }
            }
        }
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            this.elements.clear();
            this.repaint();
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
            }
            return;
        }
    }

    public void objectAdded(NamingEvent namingEvent) {
        Renderable2DInterface element = (Renderable2DInterface)namingEvent.getNewBinding().getObject();
        this.elements.add(element);
    }

    public void objectRemoved(NamingEvent namingEvent) {
        Renderable2DInterface element = (Renderable2DInterface)namingEvent.getOldBinding().getObject();
        this.elements.remove(element);
    }

    public void objectRenamed(NamingEvent namingEvent) {
        this.objectRemoved(namingEvent);
        this.objectAdded(namingEvent);
    }

    public void namingExceptionThrown(NamingExceptionEvent namingEvent) {
        Logger.warning((Object)this, (String)"namingExceptionThrown", (Throwable)namingEvent.getException());
    }

    public SortedSet getElements() {
        return this.elements;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public synchronized void showGrid(boolean bool) {
        this.showGrid = bool;
        this.repaint();
    }

    public Point4i getDragLine() {
        return this.dragLine;
    }

    public boolean isDragLineEnabled() {
        return this.dragLineEnabled;
    }

    public void setDragLineEnabled(boolean dragLineEnabled) {
        this.dragLineEnabled = dragLineEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

