/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation2D;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;

public class GridPanel
extends JPanel {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int IN = 5;
    public static final int OUT = 6;
    protected static final Color GRIDCOLOR = Color.BLACK;
    protected Rectangle2D extent = null;
    protected Rectangle2D homeExtent = null;
    protected boolean showGrid = true;
    protected double gridSize = 100.0;
    protected NumberFormat formatter = NumberFormat.getInstance();
    protected Dimension lastDimension = null;

    public GridPanel(Rectangle2D extent) {
        this(extent, new Dimension(600, 600));
    }

    public GridPanel(Rectangle2D extent, Dimension size) {
        super(true);
        this.extent = extent;
        this.homeExtent = (Rectangle2D)extent.clone();
        this.setBackground(Color.WHITE);
        this.setPreferredSize(size);
        this.lastDimension = this.getSize();
    }

    public Rectangle2D getExtent() {
        return this.extent;
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.getSize().equals(this.lastDimension)) {
            this.lastDimension = this.getSize();
            this.extent = Renderable2DInterface.Util.computeVisibleExtent((Rectangle2D)this.extent, (Dimension)this.getSize());
        }
        if (this.showGrid) {
            this.drawGrid(g);
        }
    }

    public synchronized void showGrid(boolean bool) {
        this.showGrid = bool;
        this.repaint();
    }

    public synchronized void pan(int direction, double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage<=0 || >1.0");
        }
        switch (direction) {
            case 3: {
                this.extent.setRect(this.extent.getMinX() - percentage * this.extent.getWidth(), this.extent.getMinY(), this.extent.getWidth(), this.extent.getHeight());
                break;
            }
            case 4: {
                this.extent.setRect(this.extent.getMinX() + percentage * this.extent.getWidth(), this.extent.getMinY(), this.extent.getWidth(), this.extent.getHeight());
                break;
            }
            case 1: {
                this.extent.setRect(this.extent.getMinX(), this.extent.getMinY() + percentage * this.extent.getHeight(), this.extent.getWidth(), this.extent.getHeight());
                break;
            }
            case 2: {
                this.extent.setRect(this.extent.getMinX(), this.extent.getMinY() - percentage * this.extent.getHeight(), this.extent.getWidth(), this.extent.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("direction unkonw");
            }
        }
        this.repaint();
    }

    public synchronized void home() {
        this.extent = Renderable2DInterface.Util.computeVisibleExtent((Rectangle2D)this.homeExtent, (Dimension)this.getSize());
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public synchronized void zoom(int direction, double factor) {
        double newScale = Renderable2DInterface.Util.getScale((Rectangle2D)this.extent, (Dimension)this.getSize());
        switch (direction) {
            case 5: {
                newScale *= factor;
                break;
            }
            case 6: {
                newScale /= factor;
                break;
            }
            default: {
                throw new IllegalArgumentException("zoom direction unknown");
            }
        }
        this.extent.setRect(this.extent.getCenterX() - 0.5 * newScale * (double)this.getWidth(), this.extent.getCenterY() - 0.5 * newScale * (double)this.getHeight(), newScale * (double)this.getWidth(), newScale * (double)this.getHeight());
        this.repaint();
    }

    protected synchronized void drawGrid(Graphics g) {
        g.setFont(g.getFont().deriveFont(11.0f));
        g.setColor(GRIDCOLOR);
        double scale = Renderable2DInterface.Util.getScale((Rectangle2D)this.extent, (Dimension)this.getSize());
        int gridSizePixels = (int)Math.round(this.gridSize / scale);
        if (gridSizePixels < 40) {
            this.gridSize = 10.0 * this.gridSize;
            int maximumNumberOfDigits = (int)Math.max(0.0, 1.0 + Math.ceil(Math.log(1.0 / this.gridSize) / Math.log(10.0)));
            this.formatter.setMaximumFractionDigits(maximumNumberOfDigits);
            this.drawGrid(g);
            return;
        }
        if (gridSizePixels > 400) {
            int maximumNumberOfDigits = (int)Math.max(0.0, 2.0 + Math.ceil(Math.log(1.0 / this.gridSize) / Math.log(10.0)));
            this.formatter.setMaximumFractionDigits(maximumNumberOfDigits);
            this.gridSize /= 10.0;
            this.drawGrid(g);
            return;
        }
        double mod = this.extent.getMinX() % this.gridSize;
        for (int x = (int)(-Math.round(mod / scale)); x < this.getWidth(); x += gridSizePixels) {
            Point2D point = Renderable2DInterface.Util.getWorldCoordinates((Point2D)new Point2D.Double(x, 0.0), (Rectangle2D)this.extent, (Dimension)this.getSize());
            if (point == null) continue;
            String label = this.formatter.format((double)Math.round(point.getX() / this.gridSize) * this.gridSize);
            double labelWidth = ((Component)this).getFontMetrics(this.getFont()).getStringBounds(label, g).getWidth();
            if (!((double)x > labelWidth + 4.0)) continue;
            g.drawLine(x, 15, x, this.getHeight());
            g.drawString(label, (int)Math.round((double)x - 0.5 * labelWidth), 11);
        }
        mod = Math.abs(this.extent.getMinY()) % this.gridSize;
        for (int y = (int)Math.round(this.getSize().getHeight() - mod / scale); y > 15; y -= gridSizePixels) {
            Point2D point = Renderable2DInterface.Util.getWorldCoordinates((Point2D)new Point2D.Double(0.0, y), (Rectangle2D)this.extent, (Dimension)this.getSize());
            if (point == null) continue;
            String label = this.formatter.format((double)Math.round(point.getY() / this.gridSize) * this.gridSize);
            Rectangle2D labelBounds = ((Component)this).getFontMetrics(this.getFont()).getStringBounds(label, g);
            g.drawLine((int)Math.round(labelBounds.getWidth() + 4.0), y, this.getWidth(), y);
            g.drawString(label, 2, (int)Math.round((double)y + labelBounds.getHeight() * 0.3));
        }
    }
}

