/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation2D.mouse;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.vecmath.Point4i;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation2D.AnimationPanel;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.IntrospectionAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanDownAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanLeftAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanRightAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.PanUpAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.ZoomInAction;
import nl.tudelft.simulation.dsol.gui.animation2D.actions.ZoomOutAction;
import nl.tudelft.simulation.introspection.gui.IntroSpectionDialog;
import nl.tudelft.simulation.logger.Logger;

public class InputListener
implements MouseListener,
MouseWheelListener,
MouseMotionListener,
KeyListener {
    protected DSOLApplicationInterface application;
    protected AnimationPanel panel;
    protected Point2D mouseClicked = null;
    private NumberFormat formatter = NumberFormat.getInstance();

    public InputListener(DSOLApplicationInterface application, AnimationPanel panel) {
        this.application = application;
        this.panel = panel;
    }

    public void mouseClicked(MouseEvent e) {
        Object selected;
        this.panel.requestFocus();
        this.mouseClicked = e.getPoint();
        if (!e.isPopupTrigger() && (selected = this.getSelectedObject(this.getSelectedObjects(e.getPoint()))) != null) {
            new IntroSpectionDialog(selected);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.panel.requestFocus();
        this.mouseClicked = e.getPoint();
        if (e.isPopupTrigger()) {
            this.popup(e);
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e);
        } else if (e.isShiftDown() || e.getButton() == 2) {
            this.pan(this.mouseClicked, e.getPoint());
            this.panel.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int amount = e.getUnitsToScroll();
        if (amount > 0) {
            this.panel.zoom(5, 0.95 * (double)amount);
        } else if (amount < 0) {
            this.panel.zoom(6, 0.95 * (double)(-amount));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.isShiftDown()) {
            this.setDragLine(e.getPoint());
        }
        this.panel.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point2D point = Renderable2DInterface.Util.getWorldCoordinates((Point2D)mouseEvent.getPoint(), (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        String worldPoint = "null";
        if (point != null) {
            worldPoint = "world(x=" + this.formatter.format(point.getX()) + " ; y=" + this.formatter.format(point.getY()) + ")";
        }
        String mousePoint = "screen(x=" + this.formatter.format(mouseEvent.getPoint().getX()) + " ; y=" + this.formatter.format(mouseEvent.getPoint().getY()) + ")";
        this.panel.setToolTipText(worldPoint + "  " + mousePoint);
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                new PanLeftAction(this.panel).actionPerformed(new ActionEvent(this, 0, "LEFT"));
                break;
            }
            case 39: {
                new PanRightAction(this.panel).actionPerformed(new ActionEvent(this, 0, "RIGHT"));
                break;
            }
            case 38: {
                new PanUpAction(this.panel).actionPerformed(new ActionEvent(this, 0, "UP"));
                break;
            }
            case 40: {
                new PanDownAction(this.panel).actionPerformed(new ActionEvent(this, 0, "DOWN"));
                break;
            }
            case 45: {
                new ZoomOutAction(this.panel).actionPerformed(new ActionEvent(this, 0, "OUT"));
                break;
            }
            case 61: {
                new ZoomInAction(this.panel).actionPerformed(new ActionEvent(this, 0, "IN"));
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void pan(Point2D mouseClickedPoint, Point2D mouseReleasedPoint) {
        double dx = mouseReleasedPoint.getX() - mouseClickedPoint.getX();
        double dy = mouseReleasedPoint.getY() - mouseClickedPoint.getY();
        double scale = Renderable2DInterface.Util.getScale((Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        Rectangle2D.Double extent = (Rectangle2D.Double)this.panel.getExtent();
        extent.setRect(extent.getMinX() - dx * scale, extent.getMinY() + dy * scale, extent.getWidth(), extent.getHeight());
    }

    protected List getSelectedObjects(Point2D mousePoint) {
        ArrayList<LocatableInterface> targets = new ArrayList<LocatableInterface>();
        try {
            Point2D point = Renderable2DInterface.Util.getWorldCoordinates((Point2D)mousePoint, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
            Iterator i = this.panel.getElements().iterator();
            while (i.hasNext()) {
                Renderable2DInterface renderable = (Renderable2DInterface)i.next();
                if (!renderable.contains(point, this.panel.getExtent(), this.panel.getSize())) continue;
                targets.add(renderable.getSource());
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"getSelectedObjects", (Throwable)exception);
        }
        return targets;
    }

    protected void popup(MouseEvent e) {
        List targets = this.getSelectedObjects(e.getPoint());
        if (targets.size() > 0) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add("Introspect");
            popupMenu.add(new JSeparator());
            Iterator i = targets.iterator();
            while (i.hasNext()) {
                popupMenu.add(new IntrospectionAction(i.next()));
            }
            popupMenu.show(this.panel, e.getX(), e.getY());
        }
    }

    protected Object getSelectedObject(List targets) {
        LocatableInterface selectedObject = null;
        try {
            double zValue = -1.7976931348623157E308;
            Iterator i = targets.iterator();
            while (i.hasNext()) {
                LocatableInterface next = (LocatableInterface)i.next();
                double z = next.getLocation().z;
                if (!(z > zValue)) continue;
                zValue = z;
                selectedObject = next;
            }
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"edit", (Throwable)exception);
        }
        return selectedObject;
    }

    private void setDragLine(Point2D mousePosition) {
        if (mousePosition != null && this.mouseClicked != null) {
            Point4i dragLine = this.panel.getDragLine();
            dragLine.w = (int)mousePosition.getX();
            dragLine.x = (int)mousePosition.getY();
            dragLine.y = (int)this.mouseClicked.getX();
            dragLine.z = (int)this.mouseClicked.getY();
            this.panel.setDragLineEnabled(true);
        }
    }
}

