/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation3D.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

public class TranslateMouseBehavior
extends MouseBehavior {
    private double xFactor = 0.02;
    private double yFactor = 0.02;
    private Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;
    private TransformGroup rotateXGroup = null;
    private TransformGroup rotateYGroup = null;
    private Transform3D rotateX = new Transform3D();
    private Transform3D rotateY = new Transform3D();

    public TranslateMouseBehavior(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public TranslateMouseBehavior() {
        super(0);
    }

    public TranslateMouseBehavior(int flags) {
        super(flags);
    }

    public TranslateMouseBehavior(Component c) {
        super(c, 0);
    }

    public TranslateMouseBehavior(Component c, TransformGroup transformGroup) {
        super(c, transformGroup);
    }

    public TranslateMouseBehavior(Component c, int flags) {
        super(c, flags);
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.xFactor *= -1.0;
            this.yFactor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.xFactor;
    }

    public double getYFactor() {
        return this.yFactor;
    }

    public void setFactor(double factor) {
        this.xFactor = factor;
        this.yFactor = factor;
    }

    public void setFactor(double xFactor, double yFactor) {
        this.xFactor = xFactor;
        this.yFactor = yFactor;
    }

    public void setRotateXGroup(TransformGroup rotateXGroup) {
        this.rotateXGroup = rotateXGroup;
    }

    public void setRotateYGroup(TransformGroup rotateYGroup) {
        this.rotateYGroup = rotateYGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent evt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    void doProcess(MouseEvent evt) {
        this.processMouseEvent(evt);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int id = evt.getID();
            if (id == 506 && !evt.isAltDown() && evt.isMetaDown()) {
                this.x = evt.getX();
                this.y = evt.getY();
                int dx = this.x - this.x_last;
                int dy = this.y - this.y_last;
                if (!this.reset && Math.abs(dy) < 50 && Math.abs(dx) < 50) {
                    this.transformGroup.getTransform(this.currXform);
                    this.translation.x = (double)dx * this.xFactor;
                    this.translation.y = (double)(-dy) * this.yFactor;
                    this.translation.z = 0.0;
                    this.transformX.setZero();
                    if (this.rotateYGroup != null && this.rotateXGroup != null) {
                        this.rotateYGroup.getTransform(this.rotateY);
                        this.rotateXGroup.getTransform(this.rotateX);
                        this.transformX.set(this.rotateY);
                        this.transformX.mul(this.rotateX);
                        this.transformX.transform(this.translation);
                    }
                    this.transformX.set(this.translation);
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                    }
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(1, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (id == 501) {
                this.x_last = evt.getX();
                this.y_last = evt.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

