/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.editor2D.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.EditorToolbar;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities;
import nl.tudelft.simulation.logger.Logger;

public class EditorToolbarActions
implements ActionListener {
    private EditorToolbar source = null;
    private Editor2DPanel panel = null;

    public EditorToolbarActions(EditorToolbar source, Editor2DPanel panel) {
        this.source = source;
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        this.source.getSelectObject().setSelected(false);
        this.source.getNewObject().setSelected(false);
        this.source.getEditObject().setSelected(false);
        this.source.getDeleteObject().setSelected(false);
        this.panel.setSelectedMode(0);
        if (src.equals(this.source.getSelectObject())) {
            this.source.getSelectObject().setSelected(true);
            this.panel.setSelectedMode(1);
        } else if (src.equals(this.source.getNewObject())) {
            this.source.getNewObject().setSelected(true);
            this.panel.setSelectedMode(2);
            this.source.getItems().show(this.source.getNewObject(), 0, 0);
        } else if (src.equals(this.source.getEditObject())) {
            this.source.getEditObject().setSelected(true);
            this.panel.setSelectedMode(3);
        } else if (src.equals(this.source.getDeleteObject())) {
            EditorUtilities.deleteEditable(this.panel.getSelectedEditableRenderable(), this.panel);
            this.panel.setSelectedMode(1);
            this.source.getSelectObject().setSelected(true);
            this.source.getSelectObject().requestFocus();
        } else if (src instanceof JMenuItem) {
            String text = ((JMenuItem)src).getText();
            Class<?> editableClass = null;
            try {
                Map editables = Editable.listEditables();
                Set keys = editables.keySet();
                Iterator i = keys.iterator();
                boolean found = false;
                while (i.hasNext() && !found) {
                    String key = (String)i.next();
                    if (!key.equals(text)) continue;
                    String className = (String)editables.get(key);
                    editableClass = Class.forName(className);
                    found = true;
                }
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"actionPerformed", (Throwable)exception);
            }
            if (editableClass != null) {
                this.panel.setSelectedRenderableClass(editableClass);
            }
            this.source.getNewObject().setSelected(true);
            this.panel.setSelectedMode(2);
        }
    }
}

