/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.menu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewAnimation3dAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewAnimationPanelAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewContextAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewEventlistAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewLoggerAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewMemoryAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ViewStatisticsAction;
import nl.tudelft.simulation.logger.Logger;

public class WindowMenu
extends JMenu {
    private DSOLApplicationInterface application = null;

    public WindowMenu(DSOLApplicationInterface application) {
        super("Window");
        this.application = application;
        this.setMnemonic('W');
        this.initialize();
    }

    private void initialize() {
        try {
            JMenuItem contextItem = new JMenuItem(new ViewContextAction(this.application));
            this.add(contextItem);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"initialize", (Throwable)exception);
        }
        JMenuItem statisticsItem = new JMenuItem(new ViewStatisticsAction(this.application));
        this.add(statisticsItem);
        JMenuItem animationItem = new JMenuItem(new ViewAnimationPanelAction(this.application));
        this.add(animationItem);
        JMenuItem eventListItem = new JMenuItem(new ViewEventlistAction(this.application));
        this.add(eventListItem);
        JMenuItem animation3dItem = new JMenuItem(new ViewAnimation3dAction(this.application));
        this.add(animation3dItem);
        this.add(new JSeparator());
        JMenuItem loggerItem = new JMenuItem(new ViewLoggerAction(this.application));
        this.add(loggerItem);
        JMenuItem memoryItem = new JMenuItem(new ViewMemoryAction(this.application));
        this.add(memoryItem);
    }
}

