/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.windows.FileChooserFrame;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class OpenFileAction
extends AbstractAction
implements EventListenerInterface {
    private DSOLApplicationInterface application = null;

    public OpenFileAction(DSOLApplicationInterface application) {
        super("Open File");
        this.application = application;
        this.putValue("MnemonicKey", new Integer(79));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 128));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.setEnabled(false);
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"OpenFileAction", (Throwable)exception);
        }
    }

    public void actionPerformed(ActionEvent event) {
        new FileChooserFrame(this.application, "/");
    }

    public void notify(EventInterface event) {
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            if (event.getContent() == null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.application.removeListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        super.finalize();
    }
}

