/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.GUIExperimentParsingThread;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.xml.dsol.ExperimentParsingThread;

public class OpenRecentAction
extends AbstractAction
implements EventListenerInterface {
    private DSOLApplicationInterface application = null;
    private String url = null;

    public OpenRecentAction(DSOLApplicationInterface application, String url) {
        super(url);
        this.url = url;
        this.application = application;
        this.setEnabled(false);
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"OpenRecentAction", (Throwable)exception);
        }
    }

    public void notify(EventInterface event) {
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            if (event.getContent() == null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
        if (event.getType().equals((Object)ExperimentParsingThread.EXPERIMENT_PARSED_EVENT)) {
            this.application.setExperiment((Experiment)event.getContent());
        }
    }

    public void finalize() throws Throwable {
        this.application.removeListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        super.finalize();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ((Thread)((Object)new GUIExperimentParsingThread(this, null, new URL(this.url)))).start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getClass().getName().substring(exception.getClass().getName().lastIndexOf(".") + 1) + " occurred while connecting " + this.url + ".\n", "Error", 0);
        }
    }
}

