/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.statistics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.gui.panels.TablePanel;
import nl.tudelft.simulation.dsol.gui.statistics.actions.AddColumnAction;
import nl.tudelft.simulation.dsol.gui.statistics.actions.AddRowAction;
import nl.tudelft.simulation.dsol.gui.statistics.actions.DeleteColumnAction;
import nl.tudelft.simulation.dsol.gui.statistics.actions.DeleteRowAction;
import nl.tudelft.simulation.jstats.Swingable;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.InitialEventContext;

public class ChartPanel
extends JPanel
implements DropTargetListener {
    private TablePanel contentPanel = new TablePanel(2, 2);

    public ChartPanel() {
        this.initialize();
        this.validate();
        this.repaint();
        new DropTarget(this, 3, this);
    }

    public void addRow() {
        this.contentPanel.addRow();
        for (int c = 0; c < this.contentPanel.getColumns(); ++c) {
            JPanel panel = new JPanel();
            panel.setPreferredSize(this.getMaximumSize());
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.contentPanel.setCell(panel, this.contentPanel.getRows() - 1, c);
        }
    }

    public void addColumn() {
        this.contentPanel.addColumn();
        for (int r = 0; r < this.contentPanel.getRows(); ++r) {
            JPanel panel = new JPanel();
            panel.setPreferredSize(this.getMaximumSize());
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.contentPanel.setCell(panel, r, this.contentPanel.getColumns() - 1);
        }
    }

    public void deleteRow() {
        this.contentPanel.deleteRow();
    }

    public void deleteColumn() {
        this.contentPanel.deleteColumn();
    }

    public void drop(DropTargetDropEvent dropEvent) {
        try {
            Transferable tr = dropEvent.getTransferable();
            if (dropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropEvent.acceptDrop(3);
                dropEvent.dropComplete(true);
                String key = (String)tr.getTransferData(DataFlavor.stringFlavor);
                Swingable chart = (Swingable)new InitialEventContext().lookup(key);
                this.contentPanel.setCell(chart.getSwingPanel(), this.contentPanel.getRow(dropEvent.getLocation()), this.contentPanel.getColumn(dropEvent.getLocation()));
                this.validate();
                this.repaint();
            } else {
                dropEvent.rejectDrop();
            }
        }
        catch (Exception ufe) {
            Logger.warning((Object)this, (String)"drop", (Throwable)ufe);
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder());
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton addRowButton = new JButton(new AddRowAction(this));
        buttons.add(addRowButton);
        JButton deleteRowButton = new JButton(new DeleteRowAction(this));
        buttons.add(deleteRowButton);
        JButton addColumnButton = new JButton(new AddColumnAction(this));
        buttons.add(addColumnButton);
        JButton deleteColumnButton = new JButton(new DeleteColumnAction(this));
        buttons.add(deleteColumnButton);
        TablePanel buttonHolder = new TablePanel(1, 1);
        buttonHolder.setBorder(BorderFactory.createEmptyBorder());
        buttonHolder.setCell(buttons, 0, 0);
        this.add((Component)buttonHolder, "South");
        this.add((Component)this.contentPanel, "Center");
        for (int r = 0; r < this.contentPanel.getRows(); ++r) {
            for (int c = 0; c < this.contentPanel.getColumns(); ++c) {
                JPanel panel = new JPanel();
                panel.setPreferredSize(this.getMaximumSize());
                panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                this.contentPanel.setCell(panel, r, c);
            }
        }
    }
}

