/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.tudelft.simulation.dsol.gui.panels.TablePanel;
import nl.tudelft.simulation.logger.Logger;

public class MemoryFrame
extends JFrame
implements ActionListener {
    private JTextField freeMemoryField = new JTextField();
    private JTextField totalMemoryField = new JTextField();
    private JTextField usedMemoryField = new JTextField();

    public MemoryFrame() {
        super("Memory information");
        this.setDefaultCloseOperation(2);
        this.initialize();
        new Worker(this).start();
        this.pack();
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private void initialize() {
        this.freeMemoryField.setEditable(false);
        this.usedMemoryField.setEditable(false);
        this.totalMemoryField.setEditable(false);
        JPanel panel = new JPanel(new BorderLayout());
        TablePanel buttonPanel = new TablePanel(1, 1);
        JButton button = new JButton("Clean garbage now !");
        button.addActionListener(this);
        buttonPanel.setCell(button, 0, 0);
        panel.add((Component)buttonPanel, "South");
        TablePanel memoryPanel = new TablePanel(3, 2);
        memoryPanel.setBorder(BorderFactory.createTitledBorder("Memory"));
        JTextField freeLabel = new JTextField("Free memory (bytes)");
        freeLabel.setEditable(false);
        JTextField usedLabel = new JTextField("Used memory (bytes)");
        usedLabel.setEditable(false);
        JTextField totalLabel = new JTextField("Total memory (bytes)");
        totalLabel.setEditable(false);
        memoryPanel.setCell(freeLabel, 0, 0);
        memoryPanel.setCell(usedLabel, 1, 0);
        memoryPanel.setCell(totalLabel, 2, 0);
        memoryPanel.setCell(this.freeMemoryField, 0, 1);
        memoryPanel.setCell(this.usedMemoryField, 1, 1);
        memoryPanel.setCell(this.totalMemoryField, 2, 1);
        panel.add((Component)memoryPanel, "Center");
        this.setContentPane(panel);
        this.validate();
    }

    public void actionPerformed(ActionEvent event) {
        Runtime.getRuntime().gc();
        this.repaint();
    }

    protected JTextField getFreeMemoryField() {
        return this.freeMemoryField;
    }

    protected JTextField getTotalMemoryField() {
        return this.totalMemoryField;
    }

    protected JTextField getUsedMemoryField() {
        return this.usedMemoryField;
    }

    private class Worker
    extends Thread {
        private NumberFormat formatter = NumberFormat.getInstance();
        private MemoryFrame frame = null;

        public Worker(MemoryFrame frame) {
            this.frame = frame;
            this.formatter.setMaximumFractionDigits(1);
        }

        public void run() {
            try {
                while (true) {
                    long free = Runtime.getRuntime().freeMemory();
                    long total = Runtime.getRuntime().totalMemory();
                    long used = total - free;
                    this.frame.getFreeMemoryField().setText(free + "  (" + this.formatter.format((double)free / (double)total * 100.0) + "%)");
                    this.frame.getUsedMemoryField().setText(used + "  (" + this.formatter.format((double)used / (double)total * 100.0) + "%)");
                    this.frame.getTotalMemoryField().setText(total + "  (100.0%)");
                    MemoryFrame.this.validate();
                    MemoryFrame.this.repaint();
                    Thread.sleep(3500L);
                }
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"run", (Throwable)exception);
                return;
            }
        }
    }
}

