/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.windows.DSOLFrame;
import nl.tudelft.simulation.dsol.simulators.Animator;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.logger.Logger;

public class DSOLApplication
extends EventProducer
implements DSOLApplicationInterface {
    protected Experiment experiment = null;
    protected Properties properties = new Properties();
    protected TreeSet recents = new TreeSet(new RecentComparator());
    static /* synthetic */ Class class$nl$tudelft$simulation$logger$handlers$MemoryHandler;

    public DSOLApplication() {
        Runtime.runFinalizersOnExit((boolean)true);
        Logger.setDefaultHandler((Class)(class$nl$tudelft$simulation$logger$handlers$MemoryHandler == null ? (class$nl$tudelft$simulation$logger$handlers$MemoryHandler = DSOLApplication.class$("nl.tudelft.simulation.logger.handlers.MemoryHandler")) : class$nl$tudelft$simulation$logger$handlers$MemoryHandler));
        try {
            this.readProperties(this.properties);
            new DSOLFrame(this);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"DSOLApplicationInterface", (Throwable)exception);
        }
    }

    protected void finalize() throws Throwable {
        this.writeProperties(this.properties);
        super.finalize();
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
        if (this.experiment != null && this.experiment.getUrl() != null) {
            this.recents.add(new Recent(experiment.getUrl().toString(), System.currentTimeMillis()));
            Object[] elements = this.recents.toArray();
            this.recents.clear();
            this.recents.addAll(Arrays.asList(elements));
            try {
                this.writeProperties(this.properties);
                this.experiment.setSimulator((SimulatorInterface)new Animator());
                this.experiment.start();
                this.experiment.getSimulator().stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fireEvent(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, experiment);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static void main(String[] args) {
        new DSOLApplication();
    }

    private void readProperties(Properties properties) throws IOException {
        String fileName;
        String tempPath = System.getProperty("java.io.tmpdir");
        File file = new File(tempPath, fileName = this.getClass().getName() + "_dsol.properties");
        if (file.exists()) {
            FileInputStream stream = new FileInputStream(file);
            properties.load(stream);
            stream.close();
        } else {
            properties.load(URLResource.getResourceAsStream((String)"/dsol.properties"));
        }
        int i = 0;
        String value = null;
        while ((value = properties.getProperty("recent[" + i + "]")) != null) {
            String[] elements = value.split("!#!");
            this.recents.add(new Recent(elements[0], Long.parseLong(elements[1])));
            ++i;
        }
    }

    private void writeProperties(Properties properties) throws IOException {
        String fileName;
        int loop = 0;
        Iterator i = this.recents.iterator();
        while (i.hasNext()) {
            Recent recent = (Recent)i.next();
            if (loop <= 5) {
                ((Hashtable)this.properties).put("recent[" + loop + "]", recent.getLabel() + "!#!" + recent.getExecutionTime());
            }
            ++loop;
        }
        String tempPath = System.getProperty("java.io.tmpdir");
        File file = new File(tempPath, fileName = this.getClass().getName() + "_dsol.properties");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        this.properties.store(outputStream, "");
        outputStream.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Recent {
        private String label = null;
        protected long executionTime = 0L;

        public Recent(String label, long executionTime) {
            this.executionTime = executionTime;
            this.label = label;
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private static class RecentComparator
    implements Comparator {
        private RecentComparator() {
        }

        public int compare(Object o1, Object o2) {
            Recent r1 = (Recent)o1;
            Recent r2 = (Recent)o2;
            if (r1.getLabel().equals(r2.getLabel())) {
                long executionTime;
                r1.executionTime = executionTime = Math.max(r1.getExecutionTime(), r2.getExecutionTime());
                r2.executionTime = executionTime;
                return 0;
            }
            return new Long(r2.getExecutionTime()).compareTo(new Long(r1.getExecutionTime()));
        }
    }
}

