/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.rmi.RemoteException;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class AnimationDelaySlider
extends JSlider
implements EventListenerInterface,
ChangeListener {
    private AnimatorInterface simulator;
    private boolean fired = false;

    public AnimationDelaySlider(DSOLApplicationInterface application) {
        super(0, 3000, 100);
        this.setEnabled(false);
        this.addChangeListener(this);
        try {
            application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)application, (Object)application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"AnimationDelaySlider", (Throwable)exception);
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (this.simulator == null) {
            return;
        }
        if (this.fired) {
            this.fired = false;
            return;
        }
        this.fired = true;
        try {
            boolean shoudPause = this.simulator.isRunning();
            JSlider slider = (JSlider)event.getSource();
            double value = Math.pow(10.0, (double)slider.getValue() / 1000.0) - 1.0;
            if (shoudPause) {
                this.simulator.stop();
            }
            this.simulator.setAnimationDelay(Math.round(value));
            if (shoudPause) {
                this.simulator.start();
            }
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"stateChanged", (Throwable)exception);
        }
    }

    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals((Object)AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT) && event.getSource() instanceof SimulatorInterface) {
            this.setValue((int)Math.round(Math.log(((Long)event.getContent()).longValue()) / Math.log(10.0) * 1000.0));
        }
        if (event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT) && event.getSource() instanceof DSOLApplicationInterface) {
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
            }
            return;
        }
        if (event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT) && event.getSource() instanceof Experiment && event.getContent() != null && event.getContent() instanceof AnimatorInterface) {
            this.simulator = (AnimatorInterface)event.getContent();
            this.notify((EventInterface)new Event(AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT, (Object)this.simulator, (Object)new Long(this.simulator.getAnimationDelay())));
            this.simulator.addListener((EventListenerInterface)this, AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT);
            this.setEnabled(true);
        }
    }
}

