/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation3D;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.VirtualUniverse;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import nl.tudelft.simulation.dsol.animation.D3.Renderable3DInterface;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation3D.ContentBranch;
import nl.tudelft.simulation.dsol.gui.animation3D.ViewBranch;
import nl.tudelft.simulation.dsol.gui.animation3D.mouse.PickObjectMouseBehavior;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.InitialEventContext;

public class Animation3DCanvas
extends Canvas3D
implements EventListenerInterface,
NamespaceChangeListener {
    private DSOLApplicationInterface application = null;
    private EventContext context = null;
    private ViewBranch viewBranch = null;
    private ContentBranch contentBranch = null;

    public Animation3DCanvas(DSOLApplicationInterface application) {
        super(SimpleUniverse.getPreferredConfiguration());
        this.application = application;
        this.initializePanel();
        this.initializeSubscription();
    }

    public void initializePanel() {
        ((Component)((Object)this)).setFocusable(true);
        VirtualUniverse universe = new VirtualUniverse();
        Locale locale = new Locale(universe);
        this.viewBranch = new ViewBranch(this);
        this.contentBranch = new ContentBranch();
        new PickObjectMouseBehavior(this, this.contentBranch, (Bounds)new BoundingSphere());
        locale.addBranchGraph((BranchGroup)this.viewBranch);
        locale.addBranchGraph((BranchGroup)this.contentBranch);
    }

    private void initializeSubscription() {
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"initialize", (Throwable)exception);
        }
    }

    public void notify(EventInterface event) throws RemoteException {
        AnimatorInterface simulator;
        if (event.getSource() instanceof AnimatorInterface && event.getType().equals((Object)AnimatorInterface.UPDATE_ANIMATION_EVENT)) {
            if (this.getWidth() > 0 || this.getHeight() > 0) {
                this.updateElements();
            }
            return;
        }
        if (event.getSource() instanceof AnimatorInterface && event.getType().equals((Object)SimulatorInterface.START_REPLICATION_EVENT)) {
            this.contentBranch.getDynamicObjectBranch().removeAllChildren();
            this.contentBranch.getStaticObjectBranch().removeAllChildren();
            simulator = (AnimatorInterface)event.getSource();
            String contextName = this.application.getExperiment().getRun() + "/treatment(" + simulator.getReplication().getRunControl().getTreatment().getNumber() + ")/replication(" + simulator.getReplication().getNumber() + ")/animation/3D";
            try {
                if (this.context != null) {
                    this.context.removeNamingListener(this);
                }
                this.context = (EventContext)new InitialEventContext().lookup(contextName);
                this.context.addNamingListener("", 2, (NamingListener)this);
                NamingEnumeration<Binding> list = this.context.listBindings("");
                while (list.hasMore()) {
                    Binding binding = list.next();
                    this.objectAdded(new NamingEvent(this.context, -1, binding, binding, null));
                }
                this.updateElements();
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"notify", (Throwable)exception);
            }
        }
        if (event.getSource() instanceof Experiment && event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT)) {
            this.contentBranch.getDynamicObjectBranch().removeAllChildren();
            this.contentBranch.getStaticObjectBranch().removeAllChildren();
            this.updateElements();
            if (event.getContent() instanceof AnimatorInterface && event.getContent() != null) {
                simulator = (AnimatorInterface)event.getContent();
                simulator.addListener((EventListenerInterface)this, AnimatorInterface.UPDATE_ANIMATION_EVENT);
                if (simulator.getReplication() != null) {
                    this.notify((EventInterface)new Event(SimulatorInterface.START_REPLICATION_EVENT, (Object)simulator, (Object)simulator));
                } else {
                    simulator.addListener((EventListenerInterface)this, SimulatorInterface.START_REPLICATION_EVENT);
                }
            }
        }
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            this.contentBranch.getDynamicObjectBranch().removeAllChildren();
            this.contentBranch.getStaticObjectBranch().removeAllChildren();
            this.updateElements();
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
            }
            return;
        }
    }

    public void objectAdded(NamingEvent namingEvent) {
        Renderable3DInterface element = (Renderable3DInterface)namingEvent.getNewBinding().getObject();
        BranchGroup model = (BranchGroup)element;
        if (model != null) {
            if (element.getType() != 1) {
                this.contentBranch.getStaticObjectBranch().addChild((Node)model);
            } else {
                this.contentBranch.getDynamicObjectBranch().addChild((Node)model);
            }
        }
    }

    public void objectRemoved(NamingEvent namingEvent) {
        System.out.println("Animation3d: Object removed");
        Renderable3DInterface element = (Renderable3DInterface)namingEvent.getOldBinding().getObject();
        this.contentBranch.getDynamicObjectBranch().removeChild((Node)((BranchGroup)element));
    }

    public void objectRenamed(NamingEvent namingEvent) {
        this.objectRemoved(namingEvent);
        this.objectAdded(namingEvent);
    }

    public void namingExceptionThrown(NamingExceptionEvent namingEvent) {
        Logger.warning((Object)this, (String)"namingExceptionThrown", (Throwable)namingEvent.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateElements() {
        BranchGroup dynamicObjectBranch = this.contentBranch.getDynamicObjectBranch();
        Animation3DCanvas animation3DCanvas = this;
        synchronized (animation3DCanvas) {
            for (int i = 0; i < dynamicObjectBranch.numChildren(); ++i) {
                Renderable3DInterface element = (Renderable3DInterface)dynamicObjectBranch.getChild(i);
                element.update();
            }
        }
    }

    public ContentBranch getContentBranch() {
        return this.contentBranch;
    }

    public ViewBranch getViewBranch() {
        return this.viewBranch;
    }
}

