/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation3D;

import java.awt.Component;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import nl.tudelft.simulation.dsol.gui.animation3D.mouse.RotateXYMouseBehavior;
import nl.tudelft.simulation.dsol.gui.animation3D.mouse.TranslateMouseBehavior;
import nl.tudelft.simulation.dsol.gui.animation3D.mouse.ZoomMouseBehavior;

public class ViewBranch
extends BranchGroup {
    protected Transform3D rotateX = new Transform3D();
    protected Transform3D rotateY = new Transform3D();
    protected Transform3D zoom = new Transform3D();
    protected Transform3D translation = new Transform3D();
    protected TransformGroup rotateYGroup;
    protected TransformGroup rotateXGroup;
    protected TransformGroup zoomGroup;
    protected TransformGroup translateGroup;

    public ViewBranch(Canvas3D canvas3D) {
        this.createBranch(canvas3D);
    }

    protected void createBranch(Canvas3D canvas3D) {
        this.rotateX.set(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rotateY.set(new Vector3f(0.0f, 0.0f, 0.0f));
        this.zoom.set(new Vector3f(0.0f, 0.0f, 10.0f));
        this.translation.set(new Vector3f(0.0f, 1.0f, 0.0f));
        this.rotateYGroup = new TransformGroup(this.rotateY);
        this.rotateXGroup = new TransformGroup(this.rotateX);
        this.zoomGroup = new TransformGroup(this.zoom);
        this.translateGroup = new TransformGroup(this.translation);
        this.rotateYGroup.setCapability(17);
        this.rotateYGroup.setCapability(18);
        this.rotateXGroup.setCapability(17);
        this.rotateXGroup.setCapability(18);
        this.zoomGroup.setCapability(17);
        this.zoomGroup.setCapability(18);
        this.translateGroup.setCapability(17);
        this.translateGroup.setCapability(18);
        ViewPlatform viewPlatform = new ViewPlatform();
        RotateXYMouseBehavior mouseRotate = new RotateXYMouseBehavior(2);
        mouseRotate.setTransformGroup(this.rotateYGroup);
        mouseRotate.setTransformGroupX(this.rotateXGroup);
        mouseRotate.setFactor(0.1);
        this.rotateYGroup.addChild((Node)mouseRotate);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
        mouseRotate.setSchedulingBounds((Bounds)bounds);
        ZoomMouseBehavior mouseZoom = new ZoomMouseBehavior((Component)canvas3D, 2);
        mouseZoom.setTransformGroup(this.translateGroup);
        mouseZoom.setSchedulingBounds((Bounds)bounds);
        mouseZoom.setRotateXGroup(this.rotateXGroup);
        mouseZoom.setRotateYGroup(this.rotateYGroup);
        this.zoomGroup.addChild((Node)mouseZoom);
        TranslateMouseBehavior mouseTranslate = new TranslateMouseBehavior((Component)canvas3D, 2);
        mouseTranslate.setTransformGroup(this.translateGroup);
        mouseTranslate.setSchedulingBounds((Bounds)bounds);
        mouseTranslate.setRotateXGroup(this.rotateXGroup);
        mouseTranslate.setRotateYGroup(this.rotateYGroup);
        this.translateGroup.addChild((Node)mouseTranslate);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.translateGroup.addChild((Node)this.rotateYGroup);
        this.rotateYGroup.addChild((Node)this.rotateXGroup);
        this.rotateXGroup.addChild((Node)this.zoomGroup);
        this.zoomGroup.addChild((Node)viewPlatform);
        this.addChild((Node)this.translateGroup);
        View view = new View();
        view.setBackClipDistance(5000.0);
        view.addCanvas3D(canvas3D);
        view.attachViewPlatform(viewPlatform);
        view.setPhysicalBody(body);
        view.setPhysicalEnvironment(environment);
    }

    public void resetView() {
        this.rotateYGroup.setTransform(this.rotateY);
        this.rotateXGroup.setTransform(this.rotateX);
        this.zoomGroup.setTransform(this.zoom);
        this.translateGroup.setTransform(this.translation);
    }

    public Transform3D getRotateX() {
        return this.rotateX;
    }

    public Transform3D getRotateY() {
        return this.rotateY;
    }

    public Transform3D getTranslation() {
        return this.translation;
    }

    public Transform3D getZoom() {
        return this.zoom;
    }

    public void setRotateX(Transform3D rotateX) {
        this.rotateX = rotateX;
        this.rotateXGroup.setTransform(rotateX);
    }

    public void setRotateY(Transform3D rotateY) {
        this.rotateY = rotateY;
        this.rotateYGroup.setTransform(rotateY);
    }

    public void setTranslation(Transform3D translation) {
        this.translation = translation;
        this.translateGroup.setTransform(translation);
    }

    public void setZoom(Transform3D zoom) {
        this.zoom = zoom;
        this.zoomGroup.setTransform(zoom);
    }
}

