/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation3D.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class RotateXYMouseBehavior
extends MouseBehavior {
    private double yAngle;
    private double yFactor;
    private double xAngle;
    private double xFactor;
    private TransformGroup transformGroupX = null;

    public RotateXYMouseBehavior(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public RotateXYMouseBehavior() {
        super(0);
    }

    public RotateXYMouseBehavior(int flags) {
        super(flags);
    }

    public void initialize() {
        super.initialize();
        this.yAngle = 0.0;
        this.yFactor = 0.03;
        this.xAngle = 0.0;
        this.xFactor = 0.03;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.yFactor *= -1.0;
            this.xFactor *= -1.0;
        }
    }

    public double getYFactor() {
        return this.yFactor;
    }

    public void setFactor(double factor) {
        this.yFactor = factor;
        this.xFactor = factor;
    }

    public double getXFactor() {
        return this.xFactor;
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                this.processMouseEvent((MouseEvent)event[i]);
                if ((!this.buttonPress || (this.flags & 1) != 0) && (!this.wakeUp || (this.flags & 1) == 0)) continue;
                int id = event[i].getID();
                if (id == 506 && !((MouseEvent)event[i]).isMetaDown() && !((MouseEvent)event[i]).isAltDown()) {
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    int dx = this.x - this.x_last;
                    int dy = this.y - this.y_last;
                    if (!this.reset) {
                        this.yAngle = (double)dx * this.yFactor;
                        this.xAngle = (double)dy * this.xFactor;
                        this.transformY.rotY(this.yAngle);
                        this.transformX.rotX(0.0);
                        this.transformGroup.getTransform(this.currXform);
                        Matrix4d mat = new Matrix4d();
                        this.currXform.get(mat);
                        this.currXform.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                        if (this.invert) {
                            this.currXform.mul(this.currXform, this.transformX);
                            this.currXform.mul(this.currXform, this.transformY);
                        } else {
                            this.currXform.mul(this.transformX, this.currXform);
                            this.currXform.mul(this.transformY, this.currXform);
                        }
                        Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                        this.currXform.setTranslation(translation);
                        this.transformGroup.setTransform(this.currXform);
                        this.transformY.rotY(0.0);
                        this.transformX.rotX(this.xAngle);
                        this.transformGroupX.getTransform(this.currXform);
                        this.currXform.get(mat);
                        this.currXform.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                        if (this.invert) {
                            this.currXform.mul(this.currXform, this.transformX);
                            this.currXform.mul(this.currXform, this.transformY);
                        } else {
                            this.currXform.mul(this.transformX, this.currXform);
                            this.currXform.mul(this.transformY, this.currXform);
                        }
                        translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                        this.currXform.setTranslation(translation);
                        this.transformGroupX.setTransform(this.currXform);
                    } else {
                        this.reset = false;
                    }
                    this.x_last = this.x;
                    this.y_last = this.y;
                    continue;
                }
                if (id != 501) continue;
                this.x_last = ((MouseEvent)event[i]).getX();
                this.y_last = ((MouseEvent)event[i]).getY();
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public TransformGroup getTransformGroupX() {
        return this.transformGroupX;
    }

    public void setTransformGroupX(TransformGroup group) {
        this.transformGroupX = group;
    }
}

