/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.menu;

import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.menu.actions.CloseExperimentAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.ExitAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenFileAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenRecentAction;
import nl.tudelft.simulation.dsol.gui.menu.actions.OpenURLAction;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class FileMenu
extends JMenu
implements EventListenerInterface {
    private DSOLApplicationInterface application = null;

    public FileMenu(DSOLApplicationInterface application) {
        super("File");
        this.application = application;
        this.setMnemonic('F');
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"FileMenu", (Throwable)exception);
        }
        this.initialize();
    }

    private void initialize() {
        JMenuItem openFileItem = new JMenuItem(new OpenFileAction(this.application));
        this.add(openFileItem);
        JMenuItem openURLItem = new JMenuItem(new OpenURLAction(this.application));
        this.add(openURLItem);
        JMenuItem closeURLItem = new JMenuItem(new CloseExperimentAction(this.application));
        this.add(closeURLItem);
        this.add(new JSeparator());
        this.add(this.createRecent());
        this.add(new JSeparator());
        JMenuItem exitItem = new JMenuItem(new ExitAction(this.application));
        this.add(exitItem);
    }

    private JMenu createRecent() {
        JMenu recent = new JMenu("Open Recent");
        for (int i = 0; i < 3; ++i) {
            String label = this.application.getProperties().getProperty("recent[" + i + "]");
            if (label == null || label.length() <= 0) continue;
            JMenuItem recentItem = new JMenuItem(new OpenRecentAction(this.application, label.split("!#!")[0]));
            recent.add(recentItem);
        }
        return recent;
    }

    public void notify(EventInterface event) {
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            this.remove(4);
            this.add((Component)this.createRecent(), 4);
        }
    }
}

