/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.experiment.TimeUnitInterface;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.actions.AnimationDelaySlider;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class ControlPanel
extends JPanel
implements EventListenerInterface {
    private AnimationDelaySlider animationDelaySlider;
    private JTextField animationDelayTextField = null;
    protected JTextField timeStepTextField = null;
    private JPanel timeStepPanel = new JPanel();
    private NumberFormat animationDelayFormatter = NumberFormat.getInstance();
    protected DSOLApplicationInterface application = null;

    public ControlPanel(DSOLApplicationInterface application) {
        this.application = application;
        this.animationDelayFormatter.setMinimumFractionDigits(0);
        this.animationDelayFormatter.setMaximumFractionDigits(0);
        this.initialize();
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"ControlPanel", (Throwable)exception);
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.setBorder(BorderFactory.createEmptyBorder());
        this.timeStepPanel.setLayout(new BorderLayout());
        String title = TimeUnitInterface.UNIT.toString();
        this.timeStepPanel.setBorder(BorderFactory.createTitledBorder("time step ( " + title + " on simulation clock )"));
        JTextField timeSteplabel = new JTextField("time step:  ");
        this.timeStepPanel.add((Component)timeSteplabel, "West");
        this.timeStepTextField = new JTextField();
        this.timeStepTextField.setEditable(true);
        Font font = this.timeStepTextField.getFont().deriveFont(1);
        this.timeStepTextField.setFont(font);
        this.timeStepTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DESSSimulatorInterface simulator = (DESSSimulatorInterface)ControlPanel.this.application.getExperiment().getSimulator();
                try {
                    double value = new Double(e.getActionCommand());
                    if (value <= 0.0) {
                        throw new NumberFormatException("timeStep value <=0");
                    }
                    simulator.setTimeStep(value);
                }
                catch (Exception numberFormatException) {
                    Logger.warning((Object)this, (String)"timeStepEditor", (Throwable)numberFormatException);
                    double value = 0.1;
                    try {
                        value = simulator.getTimeStep();
                    }
                    catch (RemoteException e1) {
                        Logger.warning((Object)this, (String)"nonsense", (Throwable)e1);
                    }
                    ControlPanel.this.timeStepTextField.setText(value + "");
                }
            }
        });
        this.timeStepTextField.setBorder(BorderFactory.createEmptyBorder());
        this.timeStepPanel.add((Component)this.timeStepTextField, "Center");
        content.add(this.timeStepPanel);
        JPanel animationDelayPanel = new JPanel();
        animationDelayPanel.setLayout(new BorderLayout());
        animationDelayPanel.setBorder(BorderFactory.createTitledBorder("animation delay ( milliseconds on wall clock ) "));
        this.animationDelaySlider = new AnimationDelaySlider(this.application);
        this.animationDelaySlider.setName("animationDelaySlider");
        this.animationDelaySlider.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        animationDelayPanel.add((Component)this.animationDelaySlider, "Center");
        this.animationDelayTextField = new JTextField();
        this.animationDelayTextField.setEditable(false);
        this.animationDelayTextField.setBorder(BorderFactory.createEmptyBorder());
        animationDelayPanel.add((Component)this.animationDelayTextField, "East");
        try {
            this.timeStepTextField.setText("0.1");
            this.animationDelayTextField.setText(this.animationDelayFormatter.format(0L));
            this.animationDelaySlider.setValue((int)Math.round(Math.log(0.0) / Math.log(10.0) * 1000.0));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"initialize", (Throwable)exception);
        }
        content.add(animationDelayPanel);
        this.add(content);
    }

    public void notify(EventInterface event) throws RemoteException {
        SimulatorInterface simulator;
        if (event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT) && event.getSource() instanceof DSOLApplicationInterface) {
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
            }
            return;
        }
        if (event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT) && event.getSource() instanceof Experiment) {
            if (event.getContent() != null) {
                AnimatorInterface simulator2 = (AnimatorInterface)event.getContent();
                simulator2.addListener((EventListenerInterface)this, AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT);
                simulator2.addListener((EventListenerInterface)this, DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT);
                simulator2.addListener((EventListenerInterface)this, SimulatorInterface.START_REPLICATION_EVENT);
                this.notify((EventInterface)new Event(AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT, (Object)simulator2, (Object)new Long(simulator2.getAnimationDelay())));
                this.notify((EventInterface)new Event(SimulatorInterface.START_REPLICATION_EVENT, (Object)simulator2, null));
                this.notify((EventInterface)new Event(DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT, (Object)simulator2, (Object)new Double(simulator2.getTimeStep())));
            }
            return;
        }
        if (event.getSource() instanceof SimulatorInterface && event.getType().equals((Object)SimulatorInterface.START_REPLICATION_EVENT) && (simulator = (SimulatorInterface)event.getSource()).getReplication() != null) {
            this.timeStepPanel.setBorder(BorderFactory.createTitledBorder("time step ( " + simulator.getReplication().getRunControl().getTreatment().getTimeUnit().toString() + " on simulation clock )"));
            this.validate();
            this.repaint();
            return;
        }
        if (event.getSource() instanceof AnimatorInterface) {
            if (event.getType().equals((Object)AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT)) {
                this.animationDelayTextField.setText(this.animationDelayFormatter.format((Long)event.getContent()));
            }
            if (event.getType().equals((Object)DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT)) {
                this.timeStepTextField.setText(event.getContent().toString());
            }
            this.validate();
            this.repaint();
            return;
        }
    }
}

