/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.panels;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.experiment.RunControl;
import nl.tudelft.simulation.dsol.experiment.Treatment;

public class ExperimentTree
extends DefaultTreeModel {
    public ExperimentTree(Experiment experiment) {
        super(new DefaultMutableTreeNode(experiment.getProperty("EXPERIMENT_NAME")));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        root.add(new DefaultMutableTreeNode(experiment.getProperty("EXPERIMENT_ANALYST")));
        root.add(new DefaultMutableTreeNode(experiment.getUrl()));
        for (int i = 0; i < experiment.getTreatments().length; ++i) {
            root.add(this.getTreatment(experiment.getTreatments()[i]));
        }
    }

    private DefaultMutableTreeNode getTreatment(Treatment treatment) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("Treatment");
        result.add(new DefaultMutableTreeNode("time unit=" + treatment.getTimeUnit()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(treatment.getStartTime());
        String startTime = calendar.getTime().toString();
        result.add(new DefaultMutableTreeNode("start time=" + startTime));
        result.add(this.getRunControl(treatment.getRunControl()));
        result.add(this.getProperties(treatment.getProperties()));
        return result;
    }

    private DefaultMutableTreeNode getProperties(Properties properties) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("Properties");
        Enumeration keys = ((Hashtable)properties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            result.add(new DefaultMutableTreeNode(key + "(" + value + ")"));
        }
        return result;
    }

    private DefaultMutableTreeNode getRunControl(RunControl runControl) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("RunControl");
        result.add(new DefaultMutableTreeNode("run length=" + runControl.getRunLength()));
        result.add(new DefaultMutableTreeNode("warmup period=" + runControl.getWarmupPeriod()));
        for (int i = 0; i < runControl.getReplications().length; ++i) {
            result.add(this.getReplication(runControl.getReplications()[i]));
        }
        return result;
    }

    private DefaultMutableTreeNode getReplication(Replication replication) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("Replication");
        result.add(new DefaultMutableTreeNode("description=" + replication.getDescription()));
        Map streams = replication.getStreams();
        Iterator i = streams.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            result.add(new DefaultMutableTreeNode("stream(" + key + ")=" + streams.get(key)));
        }
        return result;
    }
}

