/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.actions.FastForwardAction;
import nl.tudelft.simulation.dsol.gui.actions.ResetAction;
import nl.tudelft.simulation.dsol.gui.actions.StartAction;
import nl.tudelft.simulation.dsol.gui.actions.StepAction;
import nl.tudelft.simulation.dsol.gui.actions.StopAction;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class Statusbar
extends JPanel
implements EventListenerInterface {
    private JTextField timeField = new JTextField();
    private JTextField replicationField = new JTextField();
    private JTextField treatmentField = new JTextField();
    private DSOLApplicationInterface application = null;
    private String units = null;
    private double simulatorTime = Double.NaN;

    public Statusbar(DSOLApplicationInterface application) {
        this.application = application;
        this.initialize();
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
            if (this.application.getExperiment() != null && this.application.getExperiment().getSimulator() != null && this.application.getExperiment().getSimulator().getReplication() != null) {
                this.notify((EventInterface)new Event(SimulatorInterface.START_REPLICATION_EVENT, (Object)this.application.getExperiment().getSimulator(), (Object)this.application.getExperiment().getSimulator().getReplication()));
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"Statusbar", (Throwable)exception);
        }
    }

    private void initialize() {
        Color backgroundColor = UIManager.getColor("MenuBar.background");
        this.setBackground(backgroundColor);
        this.setLayout(new BoxLayout(this, 0));
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(backgroundColor);
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        StepAction stepAction = new StepAction(this.application);
        JButton stepButton = new JButton(stepAction);
        stepButton.setText("");
        stepButton.setBackground(backgroundColor);
        stepButton.setToolTipText("steps the simulator");
        stepButton.setBorder(BorderFactory.createEmptyBorder());
        controlPanel.add(stepButton);
        StartAction startAction = new StartAction(this.application);
        JButton startButton = new JButton(startAction);
        startButton.setText("");
        startButton.setBackground(backgroundColor);
        startButton.setToolTipText("starts the simulator");
        startButton.setBorder(BorderFactory.createEmptyBorder());
        controlPanel.add(startButton);
        StopAction stopAction = new StopAction(this.application);
        JButton stopButton = new JButton(stopAction);
        stopButton.setText("");
        stopButton.setBackground(backgroundColor);
        stopButton.setToolTipText("stops the simulator");
        stopButton.setBorder(BorderFactory.createEmptyBorder());
        controlPanel.add(stopButton);
        FastForwardAction fastForwardAction = new FastForwardAction(this.application);
        JButton fastForwardButton = new JButton(fastForwardAction);
        fastForwardButton.setText("");
        fastForwardButton.setBackground(backgroundColor);
        fastForwardButton.setToolTipText("fast forwards the simulator");
        fastForwardButton.setBorder(BorderFactory.createEmptyBorder());
        controlPanel.add(fastForwardButton);
        ResetAction resetAction = new ResetAction(this.application);
        JButton resetButton = new JButton(resetAction);
        resetButton.setText("");
        resetButton.setBackground(backgroundColor);
        resetButton.setToolTipText("resets the experiment");
        resetButton.setBorder(BorderFactory.createEmptyBorder());
        controlPanel.add(resetButton);
        JPanel statusPanel = new JPanel();
        statusPanel.setBackground(backgroundColor);
        statusPanel.setBorder(BorderFactory.createEmptyBorder());
        statusPanel.setLayout(new BorderLayout());
        this.timeField.setBackground(Color.WHITE);
        this.timeField.setPreferredSize(new Dimension(200, 12));
        this.timeField.setEditable(false);
        this.timeField.setText("Time:");
        this.timeField.setToolTipText("The simulator time");
        statusPanel.add((Component)this.timeField, "West");
        JPanel eastSide = new JPanel();
        eastSide.setBackground(backgroundColor);
        eastSide.setBorder(BorderFactory.createEmptyBorder());
        eastSide.setLayout(new BorderLayout());
        this.replicationField.setBackground(Color.WHITE);
        this.replicationField.setEditable(false);
        this.replicationField.setText("Rep(-/-)");
        this.replicationField.setToolTipText("The currently running replication");
        this.treatmentField.setBackground(Color.WHITE);
        this.treatmentField.setEditable(false);
        this.treatmentField.setText("Treat(-/-)");
        this.treatmentField.setToolTipText("The currently running treatment");
        eastSide.add((Component)this.replicationField, "West");
        eastSide.add((Component)this.treatmentField, "East");
        statusPanel.add((Component)eastSide, "East");
        this.add(controlPanel);
        this.add(statusPanel);
        new TimeUpdater(this).start();
    }

    protected double getSimulatorTime() {
        return this.simulatorTime;
    }

    protected JTextField getTimeField() {
        return this.timeField;
    }

    protected String getUnits() {
        return this.units;
    }

    public void notify(EventInterface event) throws RemoteException {
        if (event.getSource() instanceof DSOLApplicationInterface) {
            if (event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
                if (event.getContent() != null) {
                    Experiment experiment = (Experiment)event.getContent();
                    experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                    this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
                }
                return;
            }
        } else if (event.getSource() instanceof Experiment && event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT)) {
            this.simulatorTime = Double.NaN;
            if (event.getContent() != null) {
                SimulatorInterface simulator = (SimulatorInterface)event.getContent();
                simulator.addListener((EventListenerInterface)this, SimulatorInterface.START_REPLICATION_EVENT);
                simulator.addListener((EventListenerInterface)this, SimulatorInterface.TIME_CHANGED_EVENT);
                this.treatmentField.setText("Treat(-/-)");
                this.replicationField.setText("Rep(-/-)");
                this.timeField.setText("Time:");
                if (simulator.getReplication() != null) {
                    this.notify((EventInterface)new Event(SimulatorInterface.START_REPLICATION_EVENT, (Object)simulator, (Object)simulator.getReplication()));
                }
                this.validate();
                this.repaint();
            }
            return;
        }
        if (event.getSource() instanceof SimulatorInterface) {
            if (event.getType().equals((Object)SimulatorInterface.START_REPLICATION_EVENT)) {
                this.units = this.application.getExperiment().getSimulator().getReplication().getRunControl().getTreatment().getTimeUnit().toString();
                int rep = ((SimulatorInterface)event.getSource()).getReplication().getNumber() + 1;
                int nrrep = ((SimulatorInterface)event.getSource()).getReplication().getRunControl().getReplications().length;
                int treat = ((SimulatorInterface)event.getSource()).getReplication().getRunControl().getTreatment().getNumber() + 1;
                int nrtreat = ((SimulatorInterface)event.getSource()).getReplication().getRunControl().getTreatment().getExperiment().getTreatments().length;
                this.replicationField.setText("Rep(" + rep + "/" + nrrep + ")");
                this.treatmentField.setText("Treat(" + treat + "/" + nrtreat + ")");
                this.validate();
                this.repaint();
                return;
            }
            if (event.getType().equals((Object)SimulatorInterface.TIME_CHANGED_EVENT)) {
                this.simulatorTime = (Double)event.getContent();
            }
        }
    }

    private class TimeUpdater
    extends Thread {
        private NumberFormat formatter = NumberFormat.getInstance();
        private int maxLength = 0;
        private Statusbar source = null;

        public TimeUpdater(Statusbar source) {
            this.source = source;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        String formattedTime = "Time:" + this.formatter.format(this.source.getSimulatorTime()) + " " + this.source.getUnits();
                        this.source.getTimeField().setText(formattedTime);
                        if (formattedTime.length() > this.maxLength) {
                            this.maxLength = formattedTime.length();
                            this.source.validate();
                        }
                        Thread.sleep(250L);
                    }
                }
                catch (Throwable throwable) {
                    Object var1_1 = null;
                    continue;
                }
                break;
            }
        }
    }
}

