/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.panels;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class TablePanel
extends JPanel {
    private DefaultTableModel content = null;

    public TablePanel(int rows, int columns) {
        this.content = new DefaultTableModel(rows, columns);
    }

    public void addRow() {
        this.content.addRow((Object[])null);
        this.validate();
    }

    public void addColumn() {
        this.content.addColumn(null);
        this.validate();
    }

    public void deleteRow() {
        if (this.content.getRowCount() == 1) {
            return;
        }
        this.content.removeRow(this.content.getRowCount() - 1);
        this.validate();
    }

    public void deleteColumn() {
        if (this.content.getColumnCount() == 1) {
            return;
        }
        DefaultTableModel result = new DefaultTableModel(this.content.getRowCount(), this.content.getColumnCount() - 1);
        for (int rows = 0; rows < this.content.getRowCount(); ++rows) {
            for (int cols = 0; cols < this.content.getColumnCount() - 1; ++cols) {
                result.setValueAt(this.content.getValueAt(rows, cols), rows, cols);
            }
        }
        this.content = result;
        this.validate();
    }

    public int getRow(Point point) {
        double heigth = (double)this.getHeight() / (double)this.getRows();
        return (int)Math.floor(point.getY() / heigth);
    }

    public int getColumn(Point point) {
        double width = (double)this.getWidth() / (double)this.getColumns();
        return (int)Math.floor(point.getX() / width);
    }

    public void setCell(Component container, int row, int column) {
        this.content.setValueAt(container, row, column);
        this.validate();
    }

    public boolean contains(Component container) {
        for (int c = 0; c < this.getColumns(); ++c) {
            for (int r = 0; r < this.getRows(); ++r) {
                if (!this.getCell(r, c).equals(container)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getCell(int row, int column) {
        double height = (double)this.getHeight() / (double)this.getRows();
        double width = (double)this.getWidth() / (double)this.getColumns();
        Point point = new Point((int)Math.round(((double)column + 0.5) * width), (int)Math.round(((double)row + 0.5) * height));
        return this.getComponentAt(point.x, point.y);
    }

    public void removeCell(int row, int column) {
        this.remove(this.getCell(row, column));
    }

    private double[] refractor(int number) {
        double[] result = new double[number];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 1.0 / (double)number * 1.0;
            if (result[i] != 1.0) continue;
            result[i] = -1.0;
        }
        return result;
    }

    public int getColumns() {
        return this.content.getColumnCount();
    }

    public int getRows() {
        return this.content.getRowCount();
    }

    public void validate() {
        this.removeAll();
        double[][] tableDefinition = new double[][]{this.refractor(this.content.getColumnCount()), this.refractor(this.content.getRowCount())};
        TableLayout layout = new TableLayout((double[][])tableDefinition);
        this.setLayout((LayoutManager)layout);
        for (int rows = 0; rows < this.content.getRowCount(); ++rows) {
            for (int cols = 0; cols < this.content.getColumnCount(); ++cols) {
                Component component = (Component)this.content.getValueAt(rows, cols);
                if (component == null) continue;
                this.add(component, "" + cols + "," + rows + ",C,C");
            }
        }
        super.validate();
        super.repaint();
    }
}

