/*
 * @(#) DSOLApplicationInterface.java Oct 24, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui;

import java.util.Properties;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;

/**
 * The DSOL Application <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.simulation.tudelft.nl/people/alexandv.html">
 *         Alexander Verbraeck </a>
 */
public interface DSOLApplicationInterface extends EventProducerInterface
{
	/** EXPERIMENT_CHANGED_EVENT is fired whenever the experiment is changed */
	EventType EXPERIMENT_CHANGED_EVENT = new EventType(
			"EXPERIMENT_CHANGED_EVENT");

	/**
	 * returns the experiment
	 * 
	 * @return Experiment
	 */
	Experiment getExperiment();

	/**
	 * sets the experiment
	 * 
	 * @param experiment the experiment
	 */
	void setExperiment(final Experiment experiment);

	/**
	 * returns the properties
	 * 
	 * @return Properties
	 */
	Properties getProperties();
}