/*
 * @(#) ShowGridAction.java Oct 24, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;

/**
 * The ResetAction <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class ResetAction extends SimulatorAction implements
		EventListenerInterface
{
	/**
	 * constructs a new ShowGridAction
	 * 
	 * @param application the application
	 */
	public ResetAction(final DSOLApplicationInterface application)
	{
		super("reset", application);
		this.putValue(Action.SMALL_ICON, new ImageIcon(this.getClass()
				.getResource("/toolbarButtonGraphics/general/Undo16.gif")));
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		Experiment experiment = this.application.getExperiment();
		experiment.reset();
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		super.notify(event);
		if (event.getType().equals(SimulatorInterface.START_EVENT))
		{
			this.setEnabled(false);
			return;
		}
		if (event.getType().equals(SimulatorInterface.STOP_EVENT))
		{
			this.setEnabled(true);
			return;
		}
		if (event.getSource() instanceof Experiment
				&& event.getType().equals(Experiment.END_OF_EXPERIMENT_EVENT))
		{
			this.setEnabled(true);
		}
	}
}