/*
 * @(#) DEVSSimulatorAction.java Oct 23, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.rmi.RemoteException;

import javax.swing.AbstractAction;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The basic simulatorAction <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public abstract class SimulatorAction extends AbstractAction implements
		EventListenerInterface
{

	/**
	 * the simulator
	 */
	protected SimulatorInterface simulator = null;


	/** the application */
	protected DSOLApplicationInterface application = null;

	/**
	 * constructs a new DEVSSimulatorAction
	 * 
	 * @param name the name of the action
	 * @param application the application
	 */
	public SimulatorAction(final String name,
			final DSOLApplicationInterface application)
	{
		super(name);
		this.application = application;
		this.setEnabled(false);
		try
		{
			this.application.addListener(this,
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
			this.notify(new Event(
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT,
					this.application, this.application.getExperiment()));
		} catch (RemoteException exception)
		{
			Logger.warning(this, "SimulatorAction", exception);
		}
	}

	/**
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable
	{
		this.application.removeListener(this,
				DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
		if (this.simulator != null)
		{
			this.simulator.removeListener(this, SimulatorInterface.START_EVENT);
			this.simulator.removeListener(this, SimulatorInterface.STOP_EVENT);
		}
		super.finalize();
	}

	/**
	 * sets the simulator
	 * 
	 * @param simulator the simulator
	 */
	protected void setSimulator(final SimulatorInterface simulator)
	{
		try
		{
			if (this.simulator != null)
			{
				simulator.removeListener(this, SimulatorInterface.START_EVENT);
				simulator.removeListener(this, SimulatorInterface.STOP_EVENT);
			}
			this.simulator = simulator;
			if (simulator == null)
			{
				this.setEnabled(false);
			} else
			{
				this.setEnabled(true);
				this.simulator
						.addListener(this, SimulatorInterface.START_EVENT);
				this.simulator.addListener(this, SimulatorInterface.STOP_EVENT);
			}
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		if (event.getType().equals(
				DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)
				&& event.getSource() instanceof DSOLApplicationInterface)
		{
			if (event.getContent() != null)
			{
				Experiment experiment = (Experiment) event.getContent();
				experiment
						.addListener(this, Experiment.SIMULATOR_CHANGED_EVENT);
				experiment
						.addListener(this, Experiment.END_OF_EXPERIMENT_EVENT);
				this.notify(new Event(Experiment.SIMULATOR_CHANGED_EVENT,
						experiment, experiment.getSimulator()));
			} else
			{
				this.setEnabled(false);
			}
			return;
		}
		if (event.getType().equals(Experiment.END_OF_EXPERIMENT_EVENT)
				&& event.getSource() instanceof Experiment)
		{
			this.setEnabled(false);
		}
		if (event.getType().equals(Experiment.SIMULATOR_CHANGED_EVENT)
				&& event.getSource() instanceof Experiment)
		{
			this.setSimulator((SimulatorInterface) event.getContent());
		}
	}
}