/*
 * @(#) Animation3DFrame.java May 10, 2004
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.animation3D;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.Statusbar;

/**
 * Animation3DFrame, a frame for 3d animation <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public final class Animation3DFrame extends JFrame implements ActionListener
{
	/** This frame */
	private static Animation3DFrame frame = null;

	/** The application */
	private DSOLApplicationInterface application = null;

	/** The animation 3d canvas */
	private Animation3DCanvas animation3DPanel = null;

	/** A home button */
	private JButton homeButton = new JButton("Home");

	/**
	 * Constructs new frame
	 * 
	 * @param application DSOL application
	 */
	private Animation3DFrame(final DSOLApplicationInterface application)
	{
		super();
		this.application = application;
		this.animation3DPanel = new Animation3DCanvas(application);
		this.initializeFrame();
	}

	/**
	 * Creates a new instance of this frame or if one already exists, then it
	 * makes it visible.
	 * 
	 * @param application DSOLApplicationInterface
	 * @return frame
	 */
	public static JFrame initialize(final DSOLApplicationInterface application)
	{
		if (frame != null)
		{
			frame.setVisible(true);
		} else
		{
			frame = new Animation3DFrame(application);
		}
		return frame;
	}

	/**
	 * Initializes the frame
	 */
	public void initializeFrame()
	{
		// ----------------------
		// Basic frame properties
		this.setTitle("Animation3D");
		this.setSize(640, 480);

		// ------------
		// Button panel
		JPanel bottom = new JPanel();
		bottom.setLayout(new BorderLayout());
		// Add statusbar
		if (this.application != null)
		{
			Statusbar statusbar = new Statusbar(this.application);
			bottom.add(BorderLayout.WEST, statusbar);
		}
		// Add buttons
		JPanel east = new JPanel();
		east.setLayout(new FlowLayout());
		east.add(BorderLayout.EAST, this.homeButton);
		bottom.add(BorderLayout.EAST, east);
		this.homeButton.addActionListener(this);

		// ----------------
		// Setup the window
		Container container = this.getContentPane();
		container.setLayout(new BorderLayout());
		container.add(BorderLayout.CENTER, this.animation3DPanel);
		container.add(BorderLayout.SOUTH, bottom);

		// What to do to exit
		addWindowListener(new java.awt.event.WindowAdapter()
		{
			public void windowClosing(final java.awt.event.WindowEvent evt)
			{
				closeFrame();
			}
		});

		this.setVisible(true);
	}

	/**
	 * Close this frame
	 */
	protected void closeFrame()
	{
		this.setVisible(false);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed
	 *      (java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		if (event.getSource() == this.homeButton)
		{
			this.animation3DPanel.getViewBranch().resetView();
		}
	}
}